% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/flows-planar.r
\name{planarflowmodel}
\alias{planarflowmodel}
\title{Planar Normalizing Flow (1D)}
\usage{
planarflowmodel(u, w, b)
}
\arguments{
\item{u}{Scalar parameter controlling the magnitude of the deformation.}

\item{w}{Scalar parameter controlling the slope of the activation.}

\item{b}{Scalar bias term.}
}
\value{
A flow model object with methods:
\itemize{
\item sampleq(n)
\item logq(z0)
\item applyflow(z0)
}
}
\description{
A simple and readable implementation of a 1-dimensional planar flow:
z_K = z_0 + u * h(wz_0 + b)
}
\details{
where:
\itemize{
\item h is a smooth activation (tanh)
\item the log-determinant is computed analytically
}

This flow is mainly useful for pedagogical purposes or as a lightweight
building block in variational inference.
}
