% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ingest.R
\name{ragnar_store_ingest}
\alias{ragnar_store_ingest}
\title{Concurrently ingest documents into a Ragnar store}
\usage{
ragnar_store_ingest(
  store,
  paths,
  prepare = function(path) markdown_chunk(read_as_markdown(path)),
  n_workers = NULL,
  progress = TRUE,
  build_index = TRUE
)
}
\arguments{
\item{store}{A \code{RagnarStore}. Currently only version 2 stores are supported.}

\item{paths}{Character vector of file paths or URLs to ingest.}

\item{prepare}{Function that converts a single path into a
\code{MarkdownDocumentChunks} object. It is called with an argument \code{path} and
should return the prepared chunks (with or without an \code{embedding} column).}

\item{n_workers}{Number of worker processes to use. Defaults to the smaller of
\code{length(paths)} and \code{parallel::detectCores()} (with a minimum of 1).}

\item{progress}{Logical; if \code{TRUE}, show a CLI progress bar.}

\item{build_index}{Logical; whether to call \code{ragnar_store_build_index()} after ingestion.}
}
\value{
\code{store}, invisibly.
}
\description{
\code{ragnar_store_ingest()} distributes document preparation work over multiple
processes using \href{https://mirai.r-lib.org}{mirai}. Each worker calls \code{prepare}
on a single path and returns the resulting chunks (and any warnings) to the
main process, which then writes them to the store.
}
