% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/embed-snowflake.R
\name{embed_snowflake}
\alias{embed_snowflake}
\title{Generate embeddings using Snowflake}
\usage{
embed_snowflake(
  x,
  account = snowflake_account(),
  credentials = NULL,
  model = "snowflake-arctic-embed-m-v1.5",
  api_args = list(),
  batch_size = 512L
)
}
\arguments{
\item{x}{x can be:
\itemize{
\item A character vector, in which case a matrix of embeddings is returned.
\item A data frame with a column named \code{text}, in which case the dataframe is
returned with an additional column named \code{embedding}.
\item Missing or \code{NULL}, in which case a function is returned that can be called
to get embeddings. This is a convenient way to partial in additional arguments like \code{model},
and is the most convenient way to produce a function that can be passed to the \code{embed} argument of \code{ragnar_store_create()}.
}}

\item{account}{A Snowflake \href{https://docs.snowflake.com/en/user-guide/admin-account-identifier}{account identifier},
e.g. \code{"testorg-test_account"}. Defaults to the value of the
\code{SNOWFLAKE_ACCOUNT} environment variable.}

\item{credentials}{A list of authentication headers to pass into
\code{\link[httr2:req_headers]{httr2::req_headers()}}, a function that returns them when called, or
\code{NULL}, the default, to use ambient credentials.}

\item{model}{string; model name}

\item{api_args}{Named list of arbitrary extra arguments appended to the body
of every chat API call. Combined with the body object generated by ellmer
with \code{\link[=modifyList]{modifyList()}}.}

\item{batch_size}{split \code{x} into batches when embedding. Integer, limit of
strings to include in a single request.}
}
\description{
Uses the \href{https://docs.snowflake.com/en/release-notes/2025/other/2025-04-14-cortex-offers-embed-rest-api}{Cortex API \code{EMBED}}
functions to generate embeddings.
}
\details{
See \href{https://docs.snowflake.com/en/user-guide/snowflake-cortex/cortex-rest-api#label-cortex-llm-embed-function}{complete documentation}.
}
\section{Authentication}{

\itemize{
\item a \emph{Programmatic Access Token} (PAT) defined via the SNOWFLAKE_PAT environment variable.
\item A static OAuth token defined via the SNOWFLAKE_TOKEN environment variable.
\item Key-pair authentication credentials defined via the SNOWFLAKE_USER and SNOWFLAKE_PRIVATE_KEY (which can be a PEM-encoded private key or a path to one) environment variables.
\item Posit Workbench-managed Snowflake credentials for the corresponding account.
\item Viewer-based credentials on Posit Connect. Requires the connectcreds package.
}
}

