% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fractional.computations.R
\name{simulate.rSPDEobj}
\alias{simulate.rSPDEobj}
\title{Simulation of a fractional SPDE using a rational SPDE approximation}
\usage{
\method{simulate}{rSPDEobj}(object, nsim = 1, seed = NULL, ...)
}
\arguments{
\item{object}{The rational SPDE approximation, computed
using \code{\link[=fractional.operators]{fractional.operators()}},
\code{\link[=matern.operators]{matern.operators()}}, or \code{\link[=spde.matern.operators]{spde.matern.operators()}}.}

\item{nsim}{The number of simulations.}

\item{seed}{an object specifying if and how the random number generator should be initialized (‘seeded’).}

\item{...}{Currently not used.}
}
\value{
A matrix with the \code{n} samples as columns.
}
\description{
The function samples a Gaussian random field based on a
pre-computed rational SPDE approximation.
}
\examples{
# Sample a Gaussian Matern process on R using a rational approximation
kappa <- 10
sigma <- 1
nu <- 0.8
range <- sqrt(8 * nu) / kappa

# create mass and stiffness matrices for a FEM discretization
x <- seq(from = 0, to = 1, length.out = 101)
fem <- rSPDE.fem1d(x)

# compute rational approximation
op <- matern.operators(
  range = range, sigma = sigma,
  nu = nu, loc_mesh = x, d = 1,
  parameterization = "matern"
)

# Sample the model and plot the result
Y <- simulate(op)
plot(x, Y, type = "l", ylab = "u(x)", xlab = "x")

}
\seealso{
\code{\link[=simulate.CBrSPDEobj]{simulate.CBrSPDEobj()}}
}
