\name{rFocal}
\alias{rFocal}
%- Also NEED an '\alias' for EACH other topic documented here.
\title{
Run FOCAL Code in R
}
\description{
rFocal is an interpreter function. It takes as input FOCAL commands and macros and 
executes the intended operations in R.  
}
\usage{
rFocal(focFile, rFile, runit=TRUE, saveit = FALSE)
}
%- maybe also 'usage' for other objects documented here.
\arguments{
\item{focFile}{
Any of the following:
 -- a text file containing valid FOCAL commands, including the line numbers.
 -- a character string or vector of character strings containing valid FOCAL commands,
      including the line numbers.
 -- an R object of class "focfile" , generated in a previous call to \code{rFocal}.
}
\item{rFile}{
A character string providing the name of a file to be created which will contain 
the interpreted code and associated tables.  If left empty, this name is generated from
the input \code{focFile}. 
}
\item{runit}{If \code{TRUE}, the R code generated is executed. 
}
\item{saveit}{If \code{TRUE}, two files are generated. One file, "runseq.txt" , is written to the current working directory. It contains the index numbers  of the R code strings executed in sequence order. The other is a file named  \code{focFile}, written to the current working directory or, if \code{focFile} is a path/filename string, to that directory.
}
}  
\details{
The FOCAL language was created in the prehistoric times before lower-case letters were available on computers. \code{rFocal} is case-insensitive with respect to the input code, should anyone wish to write new source FOCAL code.
The original FOCAL character set included an up-arrow to indicate exponentiation.
 Given the number of different UTF-8 up-arrows available, rFocal does not support this
 item. The user must replace it with "^" in any source code.
Some FOCAL commmands are unsupported because they have no functionality in the R environment.  These commands, including ERASE, MODIFY, GO, if found in the input, are captured as "comment" lines.  
The FOCAL floating-point formatting syntax is ignored at this time.
 Future revisions may incorporate this feature. 
  
}
\value{
A list object of class \code{focfile}, containing the following. 
\item{code}{A vector containing the R code equivalent to each FOCAL command. }
\item{retidx}{An array of index values used to control the sequence of R commans
executed}
\item{strnum}{An array of the FOCAL line numbers}
\item{newvar}{A collection of variable names created by the interpreter. This is used 
to re-create environment variables if the output is invoked in a future \code{rFocal} command.
Note: these data are written to \code{rFile} when \code{saveit} is \code{TRUE}. 
}
}
\references{
%% ~put references to the literature/web site here ~
See <https://en.wikipedia.org/wiki/FOCAL_(programming_language)> for a brief overview. 
The original 1968 manual can be found at <http://www.bitsavers.org/www.computer.museum.uq.edu.au/pdf/DEC-08-AJAB-D%20PDP-8-I%20FOCAL%20Programming%20Manual.pdf> 
}
\author{
Carl Witthoft,  \email{carl@witthoft.com} 
}

\examples{
##---- Should be DIRECTLY executable !! ----
##-- ==>  Define data, use random,
##--	or standard data sets, see data().
focloop <- '1.1 FOR KK = 0,5 ; TYPE "KK SQUARED IS " , KK*KK, !'
rFocal(focloop)
focvals <- c('1.1 SET X = 3','1.2 SET Y = 5','1.3 TYPE "X AND Y",!','1.4 TYPE X, Y')
rFocal(focvals)
}
% Add one or more standard keywords, see file 'KEYWORDS' in the
% R documentation directory (show via RShowDoc("KEYWORDS")):
\keyword{ misc }
