\name{mr.FDX}
\alias{mr.FDX}
\title{Multi-resolution FDX control based on resampling}

\description{Provides a threshold that guarantees multi-resolution FDX control, given a matrix of resampled test statistics}

\usage{mr.FDX(teststats,alpha,gamma,sequential=FALSE,ncombs=25)}

\arguments{
  \item{teststats}{A matrix of resampled test statistics. The first row corrresponds to the original data.}
  \item{alpha}{The desired FDX rate}
  \item{gamma}{The target (maximal) FDP}
  \item{sequential}{Set to TRUE if the (slower) sequential method should be used}
  \item{ncombs}{The nr. of random combinations that the sequential method checks.}
}

\value{The rejection threshold that guarantees multi-resolution FDX control.}

\examples{
set.seed(123)

n=10   #samle size per group
m=100  #nr. of hypotheses
w=50   #nr of random permutations

X <- matrix(rnorm((2*n)*m), 2*n, m) #make data matrix (m columns, i.e., m hypotheses)
y <- c(numeric(n)+1,numeric(n)-1)   #group labels

Y <- t(replicate(w, sample(y, size=2*n, replace=FALSE)))  #make matrix with permuted group labels
Y[1,] <- y

#Add some signal to the first 50 columns, so that 50 hypotheses are false:
X[1:n,1:50] <- X[1:n,1:50] + 1.5


#Make matrix with test statistics for permuted versions of the data:
tstats <- matrix(nr=w,nc=m) #Matrix with resampled test statistics
for(j in 1:w){
  for(i in 1:m){
    # Compute t-statistic for j-th permutation for i-th hypothesis:
    avg1 <- (sum(X[Y[j,]==1,i]))/n; avg2 <- (sum(X[Y[j,]==-1,i]))/n
    s <- sqrt( (sum( (X[Y[j,]==1,i]-avg1)^2 ) + sum( (X[Y[j,]==-1,i]-avg2)^2 )  )/(2*n-2) )
    tstats[j,i] <- abs( (avg1-avg2)/ ( sqrt(2/n) * s  )) 
  }
}


q = mr.FDX(teststats=tstats,alpha=0.1,gamma=0.1,sequential=FALSE)

#Check which hypotheses are rejected (for the maximum threshold that provides FDX control):
which( tstats[1,] > q )

}

