% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hotperm.R
\name{hotperm}
\alias{hotperm}
\alias{print.hotperm}
\alias{summary.hotperm}
\alias{print.summary.hotperm}
\alias{plot.hotperm}
\title{Conduct NL and N permutation tests}
\usage{
hotperm(
  cross,
  n.quant,
  n.perm,
  lod.thrs,
  alpha.levels,
  drop.lod = 1.5,
  window = NULL,
  verbose = FALSE,
  init.seed = 0,
  addcovar = NULL,
  intcovar = NULL,
  ...
)

\method{print}{hotperm}(x, ...)

\method{summary}{hotperm}(object, quant.levels, ...)

\method{print}{summary.hotperm}(x, ...)

\method{plot}{hotperm}(x, probs = seq(0.9, 0.99, by = 0.01), level = 0.95, ...)
}
\arguments{
\item{cross}{object of class \code{cross}}

\item{n.quant}{maximum of \code{s.quant}}

\item{n.perm}{number of permutations}

\item{lod.thrs}{vector of LOD thresholds}

\item{alpha.levels}{vector of significance levels}

\item{drop.lod}{LOD drop amount for support intervals}

\item{window}{window size for smoothed hotspot size}

\item{verbose}{verbose output if \code{TRUE}}

\item{init.seed}{initial seed for pseudo-random number generation}

\item{addcovar}{additive covariates as vector or matrix; see
\code{\link[qtl]{scanone}}}

\item{intcovar}{interactive covariates as vector or matrix; see
\code{\link[qtl]{scanone}}}

\item{\dots}{arguments passed along to \code{scanone}}

\item{x, object}{object of class \code{hotperm} or \code{summary.hotperm}}

\item{quant.levels}{quantile levels, as number of traits, to show in
summary; default is 1, 2, 5, 10, \dots up to maximum recorded}

\item{probs}{probability levels for quantiles (\code{1-probs} if all > 0.5);
default is \code{alpha.levels}}

\item{level}{Significance level for hotspot detection.}
}
\description{
This set of functions compute the permutation LOD thresholds for the NL-method
and the permutation hotspot size thresholds for the N-method. The output
is a list with two elements: the NL- and the N-method's threshold matrices.
The NL-method output is a nN (number of spurious hotspot sizes) by nalpha
(number of significance levels) threshold matrix. Note that for the
NL-method we have a single "alpha" since we use the same significance level
for QTL mapping and permutation significance.
The N-method output is a nlod (number of LOD thresholds) by nalpha (number
of significance levels) threshold matrix. Note that here we have two
"alphas", one for the QTL mapping (the LOD thresholds) and one for the 
permutation significance (alpha levels).
}
\examples{
ncross1 <- sim.null.cross(chr.len = rep(100, 4),
                          n.mar = 51,
                          n.ind = 100,
                          type = "bc",
                          n.phe = 1000,
                          latent.eff = 3,
                          res.var = 1,
                          init.seed = 123457)
cross1 <- include.hotspots(cross = ncross1,
                           hchr = c(2, 3, 4),
                           hpos = c(25, 75, 50),
                           hsize = c(100, 50, 20),
                           Q.eff = 2,
                           latent.eff = 3,
                           lod.range.1 = c(2.5, 2.5),
                           lod.range.2 = c(5, 8),
                           lod.range.3 = c(10, 15),
                           res.var = 1,
                           n.phe = 1000,
                           init.seed = 12345)
pt.scanone <- scanone(ncross1, method = "hk", n.perm = 1000)
alphas <- seq(0.01, 0.10, by=0.01)
lod.thrs <- summary(pt.scanone, alphas)
# This takes awhile, so we save the object.
\dontrun{
hotperm1 <- hotperm(cross = cross1,
                    n.quant = 300,
                    n.perm = 100,
                    lod.thrs = lod.thrs,
                    alpha.levels = alphas,
                    drop.lod = 1.5,
                    verbose = FALSE)
save(hotperm1, file = "hotperm1.RData", compress = TRUE)
# data(hotperm1) 
summary(hotperm1)
}
}
\author{
Elias Chaibub Neto and Brian S Yandell
}
\keyword{utilities}
