% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/create_format.R
\name{expand_formats}
\alias{expand_formats}
\title{Expand A List Of Formats To Generate All Possible Combinations}
\usage{
expand_formats(..., names = NULL)
}
\arguments{
\item{...}{A list containing format data frames.}

\item{names}{Custom variable names for the newly generated data frame.}
}
\value{
Returns a data frames with all format label combinations.
}
\description{
Generates a data frame which contains all nested combinations of the provided
format labels.
}
\examples{
# Example formats
sex. <- discrete_format(
    "Total"  = 1:2,
    "Male"   = 1,
    "Female" = 2)

age. <- discrete_format(
    "Total"          = 0:100,
    "under 18"       = 0:17,
    "18 to under 25" = 18:24,
    "25 to under 55" = 25:54,
    "55 to under 65" = 55:64,
    "65 and older"   = 65:100)

# Expand formats
expand_df <- expand_formats(sex., age.,
                            names = c("sex", "age"))

}
