% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/qcrlscR.R
\name{qc.rlsc}
\alias{qc.rlsc}
\title{QC based robust LOESS signal correction (QC-RLSC)}
\usage{
qc.rlsc(x, y, method = c("subtract", "divide"), opti = TRUE, ...)
}
\arguments{
\item{x}{A data frame with samples (row) and variables (column).}

\item{y}{A vector with string of "qc" and "sample".}

\item{method}{Data scaling method.}

\item{opti}{A logical value indicating whether or not optimise 'span'}

\item{...}{Other parameter for 'loess'.}
}
\value{
A corrected data frame.
}
\description{
QC based robust LOESS (locally estimated scatterplot smoothing) signal
correction (QC-RLSC)
}
\details{
This function includes only information of sample types (\code{QC} or
\code{Sample}) for signal correction. It does not require batch information.
User may use batch elimination routine such as \code{batch.shift()} in this
package or others to remove batch effects after signal correction.

If data matrix has missing values, user should filter the data based on
missing values percentage. No missing values imputation is needed.

An option is also provided to optimise LOESS's \code{span} in a range
between 0.05 to 0.95. The R codes are modified from
https://bit.ly/3zBo3Qn.
}
\examples{
names(man_qc)
data <- man_qc$data
meta <- man_qc$meta

cls.qc <- factor(meta$sample_type)
cls.bl <- factor(meta$batch)

\donttest{
## apply QC-RLSC with optimisation of 'span'
res_1 <- qc.rlsc(data, cls.qc, method = "subtract", opti = TRUE)

## apply QC-RLSC without optimisation of 'span'
res_2 <- qc.rlsc(data, cls.qc, method = "subtract", opti = FALSE)
}
}
\references{
Dunn et al. Procedures for large-scale metabolic profiling of serum and
plasma using gas chromatography and liquid chromatography coupled to
mass spectrometry. Nature Protocols 6, 1060–1083 (2011)
}
\seealso{
Other QC-RLSC function: 
\code{\link{qc.rlsc.wrap}()}
}
\concept{QC-RLSC function}
