% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rbs.R
\docType{data}
\name{rbs}
\alias{rbs}
\title{Risk Behavior Survey}
\format{
A tibble with 15,410 rows and
4 variables:

\describe{
\item{\strong{who}}{\tabular{ll}{
   \emph{Type:} \tab integer \cr
    \tab  \cr
   \emph{Description:} \tab Patient ID \cr
}


}
\item{\strong{what}}{\tabular{ll}{
   \emph{Type:} \tab factor (First/Reference level = cocaine) \cr
    \tab  \cr
   \emph{Description:} \tab What drug was used: \if{html}{\out{<ul>}}\if{html}{\out{<li>}}"cocaine" = Cocaine by itself\if{html}{\out{</li>}}\if{html}{\out{<li>}}"heroin" = Heroin by itself\if{html}{\out{</li>}}\if{html}{\out{<li>}}"opioid" = Have you ever used Other Opiates\if{html}{\out{</li>}}\if{html}{\out{<li>}}"speed" = Have you ever used Amphetamines (Speed, Methamphetamine, Crank)\if{html}{\out{</li>}}\if{html}{\out{<li>}}"speedball" = Heroin and cocaine mixed\if{html}{\out{</li>}}\if{html}{\out{</ul>}} \cr
    \tab  \cr
   \emph{Levels:} \tab cocaine, heroin, opioid, speed, speedball \cr
}


}
\item{\strong{did_use}}{\tabular{ll}{
   \emph{Type:} \tab factor (First/Reference level = No) \cr
    \tab  \cr
   \emph{Description:} \tab Is there a self-reported history of use? \cr
    \tab  \cr
   \emph{Levels:} \tab No, Yes \cr
}


}
\item{\strong{days}}{\tabular{ll}{
   \emph{Type:} \tab integer \cr
    \tab  \cr
   \emph{Description:} \tab Number of days out of 30 that the drug was used \cr
}


}
}
}
\usage{
data(rbs)
}
\description{
This is the drug use information on from the RBS. Questions ask,
"How many days did you use ___ in the last 30 days?" Days were categorized
in ctn_0051. See the
\href{../doc/harmonization.html#rbs}{Harmonization Information} vignette for
more details.
}
\keyword{datasets}
