% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utility_functions.R
\name{cast_simple}
\alias{cast_simple}
\title{Cast \code{data.table}/\code{data.frame} from long format to wide format}
\usage{
cast_simple(data = NULL, columns = NULL, rows = NULL, values = NULL)
}
\arguments{
\item{data}{a \code{data.table} or \code{data.frame}}

\item{columns}{a character string vector; the (unique combinations of the)
levels of these variable will be different rows}

\item{rows}{a character string vector; the (unique combinations of the)
levels of these variable will be different columns}

\item{values}{a character string; the variable which will be represented
on rows and columns as specified by \code{columns} and \code{rows}}
}
\value{
A \code{data.table} just like \verb{[data.table::dcast]}.
}
\description{
Convenience function for using \verb{[data.table::dcast.data.table]};
inputs are character strings (names of variables) instead of a formula.
}
\details{
This function is just a small interface for \code{dcast} /
\code{dcast.data.table} and less flexible than the originals.

Note that all \code{data.table} objects are also \code{data.frame}
objects, but that each have their own \code{dcast} method.
\verb{[data.table::dcast.data.table]} is faster.

If any values in \code{value.vars} need to be
aggregated, they are aggregated using \code{sum}.
See \code{?dcast}.
}
\examples{
library("data.table")
## e.g. silly counts from a long-format table to a wide format
test <- data.table::copy(popEpi::sire)
test$dg_y <- year(test$dg_date)
test$ex_y <- year(test$ex_date)
tab <- ltable(test, c("dg_y","ex_y"))
cast_simple(tab, columns='dg_y', rows="ex_y", values="obs")

}
\author{
Matti Rantanen, Joonas Miettinen
}
