% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ancestry.R
\name{convert_to_plink2}
\alias{convert_to_plink2}
\title{Converting PLINK v1.9 data files into PLINK v2.0 data files}
\usage{
convert_to_plink2(
  indir,
  name,
  qcdir = indir,
  verbose = FALSE,
  path2plink2 = NULL,
  keep_individuals = NULL,
  remove_individuals = NULL,
  exclude_markers = NULL,
  extract_markers = NULL,
  showPlinkOutput = TRUE
)
}
\arguments{
\item{indir}{[character] /path/to/directory containing the basic PLINK 1.9 data
file name.bim, name.fam, name.bed}

\item{name}{[character] Prefix of PLINK 1.9 files, i.e. name.bim, name.fam, 
name.bed}

\item{qcdir}{[character] /path/to/directory where the plink2 data formations
as returned by plink2 --make-pgen will be saved to. User needs writing 
permission to qcdir. Per default is qcdir=indir.}

\item{verbose}{[logical] If TRUE, progress info is printed to standard out.}

\item{path2plink2}{[character] Absolute path to PLINK executable
(\url{https://www.cog-genomics.org/plink/2.0/}) i.e.
plink 2 should be accessible as path2plink -h. The full name of the executable
should be specified: for windows OS, this means path/plink.exe, for unix
platforms this is path/plink. If not provided, assumed that PATH set-up works
and PLINK will be found by \code{\link[sys]{exec}}('plink').}

\item{keep_individuals}{[character] Path to file with individuals to be
retained in the analysis. The file has to be a space/tab-delimited text file
with family IDs in the first column and within-family IDs in the second
column. All samples not listed in this file will be removed from the current
analysis. See \url{https://www.cog-genomics.org/plink/1.9/filter#indiv}.
Default: NULL, i.e. no filtering on individuals.}

\item{remove_individuals}{[character] Path to file with individuals to be
removed from the analysis. The file has to be a space/tab-delimited text file
with family IDs in the first column and within-family IDs in the second
column. All samples listed in this file will be removed from the current
analysis. See \url{https://www.cog-genomics.org/plink/1.9/filter#indiv}.
Default: NULL, i.e. no filtering on individuals.}

\item{exclude_markers}{[character] Path to file with makers to be
removed from the analysis. The file has to be a text file with a list of
variant IDs (usually one per line, but it's okay for them to just be
separated by spaces). All listed variants will be removed from the current
analysis. See \url{https://www.cog-genomics.org/plink/1.9/filter#snp}.
Default: NULL, i.e. no filtering on markers.}

\item{extract_markers}{[character] Path to file with makers to be
included in the analysis. The file has to be a text file with a list of
variant IDs (usually one per line, but it's okay for them to just be
separated by spaces). All unlisted variants will be removed from the current
analysis. See \url{https://www.cog-genomics.org/plink/1.9/filter#snp}.
Default: NULL, i.e. no filtering on markers.}

\item{showPlinkOutput}{[logical] If TRUE, plink log and error messages are
printed to standard out.}
}
\value{
Creates plink 2.0 datafiles
}
\description{
This converts files in the PLINK v1.9 format (i.e. name.bim, name.fam, and 
name.bed) into PLINK v2.0 format (i.e. name.pvar, name.psam, and name.pgen)
}
\examples{
indir <- system.file("extdata", package="plinkQC")
qcdir <- tempdir()
name <- "data"
path2plink <- '/path/to/plink'
\dontrun{
# the following code is not run on package build, as the path2plink on the
# user system is not known.
convert_to_plink2(indir=indir, qcdir=qcdir, name=name, path2plink2 = path2plink2)
}
}
