% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/zero_order_release.R
\name{zero_order_release}
\alias{zero_order_release}
\title{Zero-Order Drug Release Kinetic Model}
\arguments{
\item{data}{A data frame containing experimental drug release data.}

\item{time_col}{Character string specifying the column name for time
(e.g., minutes or hours).}

\item{release_col}{Character string specifying the column name for cumulative
drug release (typically percentage).}

\item{group_col}{Optional character string specifying a column name used for
grouping (e.g., formulation, batch). Default is NULL.}

\item{pH_col}{Optional character string specifying a column name containing
pH values. If provided, zero-order models are fitted separately for each pH.}

\item{plot}{Logical; if TRUE, generates a plot of experimental data with
zero-order fitted straight lines (default is TRUE).}

\item{annotate}{Logical; if TRUE, annotates the plot with k0, intercept, R^2,
and t50 values for each group (default is TRUE).}
}
\value{
A list containing:
\describe{
  \item{\code{fitted_parameters}}{A data frame with k0, intercept, R^2, and t50
        values for each group or pH condition.}
  \item{\code{data}}{The processed data used for model fitting and plotting.}
}
}
\description{
Fits experimental cumulative drug release data to a zero-order kinetic model
using linear regression. The function supports optional grouping variables
(e.g., formulation, batch) and optional pH-dependent analysis. It can generate
publication-quality plots with fitted straight lines and annotations for
zero-order rate constant (k0), intercept, coefficient of determination (R^2),
and time required for 50-percent drug release (t50).
}
\examples{
# Example I: Single formulation
df_1 <- data.frame(
  time = c(0, 15, 30, 45, 60, 90, 120, 150, 180),
  release = c(0, 11.4, 20.8, 30.8, 39.8, 57.8, 72, 84.8, 93.5)
)
zero_order_release(
  data = df_1,
  time_col = "time",
  release_col = "release"
)

# Example II: Two formulations (grouped, not pH-dependent)
df_2 <- data.frame(
  time = rep(c(0, 30, 60, 90, 120, 150), 2),
  release = c(
    0, 18, 35, 55, 72, 88,   # Formulation A
    0, 12, 26, 40, 58, 70    # Formulation B
  ),
  formulation = rep(c("Formulation A", "Formulation B"), each = 6)
)
zero_order_release(
  data = df_2,
  time_col = "time",
  release_col = "release",
  group_col = "formulation"
)

# Example III: pH-dependent release
df_pH <- data.frame(
  time = rep(c(0, 60, 120, 180), 2),
  release = c(0, 40, 75, 95, 0, 30, 60, 80),
  pH = rep(c(7.4, 4.5), each = 4)
)
zero_order_release(
  data = df_pH,
  time_col = "time",
  release_col = "release",
  pH_col = "pH"
)

# Example IV: Two formulations under two pH conditions
df1 <- data.frame(
  time = rep(c(0, 30, 60, 90, 120, 150, 180), 2),
  release = c(
    0, 12, 25, 38, 52, 65, 78,   # pH 4.5
    0, 15, 30, 47, 63, 78, 90    # pH 7.6
  ),
  pH = rep(c(4.5, 7.6), each = 7)
)
df2 <- data.frame(
  time = rep(c(0, 20, 40, 60, 80, 100, 120), 2),
  release = c(
    0, 10, 22, 35, 50, 64, 77,   # pH 4.5
    0, 14, 28, 45, 61, 76, 88    # pH 7.6
  ),
  pH = rep(c(4.5, 7.6), each = 7)
)
df_all <- rbind(
  cbind(dataset = "Dataset 1", df1),
  cbind(dataset = "Dataset 2", df2)
)
zero_order_release(
  data = df_all,
  time_col = "time",
  release_col = "release",
  group_col = "dataset",
  pH_col = "pH"
)
}
\references{
Higuchi, T. (1961) <doi:10.1002/jps.2600501018> Rate of release
of medicaments from ointment bases containing drugs in suspension. Journal of
Pharmaceutical Sciences, 50(10), 874–875.
}
\author{
Paul Angelo C. Manlapaz
}
