% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ld50_model.R
\name{ld50_model}
\alias{ld50_model}
\title{Lethal Dose 50 (LD50) Pharmacodynamic Model}
\arguments{
\item{data}{A data frame containing mortality response data.}

\item{dose_col}{Character string specifying the administered dose column.}

\item{response_col}{Character string specifying the binary mortality outcome
(0 = alive, 1 = dead).}

\item{group_col}{Optional character string specifying a grouping variable.}

\item{condition_col}{Optional character string specifying an experimental condition.}

\item{plot}{Logical; if TRUE, generates dose-mortality plots.}

\item{annotate}{Logical; if TRUE, annotates the plot with LD50, confidence
intervals, and model parameters (only if <=2 groups).}
}
\value{
A list containing:
\describe{
  \item{\code{fitted_parameters}}{Data frame with LD50, 95\% confidence
        intervals, slope, intercept, and pseudo-R2 values for each group.}
  \item{\code{data}}{The processed data used for model fitting and plotting.}
}
}
\description{
Fits quantal mortality data to a logistic dose-response model
to estimate the Lethal Dose 50 (LD50), defined as the dose
expected to cause death in 50% of the test population.

The model uses binomial logistic regression and supports optional
grouping (e.g., species, sex, strain, formulation) and stratification
by experimental conditions (e.g., exposure route, duration).

In addition to LD50 estimation, the model provides the following
interpretable parameters:
\itemize{
  \item \strong{Slope}: Represents the steepness of the dose-mortality
  relationship. A larger slope indicates a rapid transition from survival
  to lethality with increasing dose (high sensitivity and narrow safety
  margin), whereas a smaller slope reflects a more gradual increase in
  mortality, suggesting greater inter-individual variability in response.

  \item \strong{Intercept}: Represents the baseline log-odds of mortality
  at zero dose. A strongly negative intercept indicates negligible
  background mortality, while a positive intercept suggests mortality
  occurring in the absence of administered dose, which may reflect
  experimental bias, underlying disease, or study design limitations.

  \item \strong{LD50 95\% Confidence Interval}: An approximate 95% confidence
  interval for the LD50, computed using the delta method. This provides
  an uncertainty range around the estimated dose causing 50% mortality.

  \item \strong{McFadden Pseudo-R\eqn{^2}}: A likelihood-based measure of
  model goodness-of-fit that quantifies the improvement of the fitted
  model over a null (intercept-only) model. Values between 0.1 and 0.2
  indicate acceptable biological fit, while values above 0.3 suggest
  a strong and reliable dose-mortality relationship.
}

The function can generate dose-response plots with fitted curves and
annotate LD50, slope, intercept, LD50 confidence intervals, and
McFadden pseudo-R\eqn{^2} values.
}
\examples{
# Example I: Single-species acute toxicity study
df1 <- data.frame(
  dose = c(10, 25, 50, 100, 200),
  dead = c(0, 0, 1, 1, 1)
)
ld50_model(
  data = df1,
  dose_col = "dose",
  response_col = "dead"
)

# Example II: Sex-dependent LD50 analysis
df2 <- data.frame(
  dose = rep(c(10, 25, 50, 100), 2),
  dead = c(0, 0, 1, 1, 0, 0, 0, 1),
  sex = rep(c("Male", "Female"), each = 4)
)
ld50_model(
  data = df2,
  dose_col = "dose",
  response_col = "dead",
  group_col = "sex"
)

# Example III: Species and exposure route comparison
df3 <- data.frame(
  dose = rep(c(20, 40, 80, 160), 4),
  dead = c(0, 0, 1, 1, 0, 1, 1, 1, 0, 0, 0, 1, 0, 0, 1, 1),
  species = rep(c("Rat", "Mouse"), each = 8),
  route = rep(c("Oral", "IP"), each = 4, times = 2)
)
ld50_model(
  data = df3,
  dose_col = "dose",
  response_col = "dead",
  group_col = "species",
  condition_col = "route"
)
}
\references{
Bliss, C. I. (1935) <doi:10.1111/j.1744-7348.1935.tb07713.x> The
calculation of the dosage-mortality curve. Annals of Applied Biology, 22(1),
134–167.

Finney, D. J. (1971) <isbn:9780521080415> Probit Analysis,
3rd Edition. Cambridge University Press, Cambridge.
}
\author{
Paul Angelo C. Manlapaz
}
