% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/helpers.R
\name{optimize_clusters}
\alias{optimize_clusters}
\title{Function to optimize clusters based on the Calinski-Harabasz index}
\usage{
optimize_clusters(
  ncs,
  class_vec,
  method = c("ks", "kmeans"),
  min_m = 2,
  max_m = NULL,
  ms = NULL,
  maxit = 100,
  q = seq(0.1, 0.9, by = 0.1)
)
}
\arguments{
\item{ncs}{Vector of non-conformity scores}

\item{class_vec}{Vector of class labels}

\item{method}{Clustering method to use, either 'ks' for Kolmogorov-Smirnov or 'kmeans' for K-means clustering}

\item{min_m}{Minimum number of clusters to consider}

\item{max_m}{Maximum number of clusters to consider. If NULL, defaults to the number of unique classes minus one}

\item{ms}{Vector of specific numbers of clusters to consider. If NULL, defaults to a sequence from min_m to max_m}

\item{maxit}{Maximum number of iterations for the clustering algorithm}

\item{q}{Quantiles to use for K-means clustering, default is a sequence from 0.1 to 0.9 in steps of 0.1}
}
\value{
A vector of cluster assignments, with attributes containing the clusters, coverage gaps, method used, number of clusters, and the Calinski-Harabasz index
}
\description{
Function to optimize clusters based on the Calinski-Harabasz index
}
