% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/adex.R
\docType{data}
\name{adex}
\alias{adex}
\title{Exposure Analysis}
\format{
A data frame with 92 columns:
\describe{
\item{ STUDYID }{Study Identifier}
\item{ USUBJID }{Unique Subject Identifier}
\item{ SUBJID }{Subject Identifier for the Study}
\item{ SITEID }{Study Site Identifier}
\item{ COUNTRY }{Country}
\item{ DOMAIN }{Domain Abbreviation}
\item{ RFSTDTC }{Subject Reference Start Date/Time}
\item{ RFENDTC }{Subject Reference End Date/Time}
\item{ RFXSTDTC }{Date/Time of First Study Treatment}
\item{ RFXENDTC }{Date/Time of Last Study Treatment}
\item{ RFPENDTC }{Date/Time of End of Participation}
\item{ SCRFDT }{Screen Failure Date}
\item{ FRVDT }{Final Retrieval Visit Date}
\item{ DTHDTC }{Date/Time of Death}
\item{ DTHADY }{Relative Day of Death}
\item{ DTHFL }{Subject Death Flag}
\item{ LDDTHELD }{Elapsed Days from Last Dose to Death}
\item{ LDDTHGR1 }{Last Dose to Death - Days Elapsed Grp 1}
\item{ DTH30FL }{Death Within 30 Days of Last Trt Flag}
\item{ DTHA30FL }{Death After 30 Days from Last Trt Flag}
\item{ DTHDOM }{Domain for Date of Death Collection}
\item{ DTHB30FL }{Death Within 30 Days of First Trt Flag}
\item{ ASEQ }{Analysis Sequence Number}
\item{ REGION1 }{Geographic Region 1}
\item{ DMDTC }{Date/Time of Collection}
\item{ DMDY }{Study Day of Collection}
\item{ AGE }{Age}
\item{ AGEU }{Age Units}
\item{ AGEGR1 }{Pooled Age Group 1}
\item{ SEX }{Sex}
\item{ RACE }{Race}
\item{ RACEGR1 }{Pooled Race Group 1}
\item{ ETHNIC }{Ethnicity}
\item{ SAFFL }{Safety Population Flag}
\item{ ARM }{Description of Planned Arm}
\item{ ARMCD }{Planned Arm Code}
\item{ ACTARM }{Description of Actual Arm}
\item{ ACTARMCD }{Actual Arm Code}
\item{ TRT01P }{Planned Treatment for Period 01}
\item{ TRT01A }{Actual Treatment for Period 01}
\item{ TRTSDT }{Date of First Exposure to Treatment}
\item{ TRTSDTM }{Datetime of First Exposure to Treatment}
\item{ TRTSTMF }{Time of First Exposure Imput. Flag}
\item{ TRTEDT }{Date of Last Exposure to Treatment}
\item{ TRTEDTM }{Datetime of Last Exposure to Treatment}
\item{ TRTETMF }{Time of Last Exposure Imput. Flag}
\item{ EOSSTT }{End of Study Status}
\item{ EOSDT }{End of Study Date}
\item{ RFICDTC }{Date/Time of Informed Consent}
\item{ RANDDT }{Date of Randomization}
\item{ LSTALVDT }{Date Last Known Alive}
\item{ TRTDURD }{Total Treatment Duration (Days)}
\item{ DTHDT }{Date of Death}
\item{ DTHDTF }{Date of Death Imputation Flag}
\item{ DTHCAUS }{Cause of Death}
\item{ DTHCGR1 }{Cause of Death Reason 1}
\item{ EXTRT }{Name of Treatment}
\item{ EXDOSE }{Dose}
\item{ EXDOSFRM }{Dose Form}
\item{ EXDOSFRQ }{Dosing Frequency per Interval}
\item{ EXROUTE }{Route of Administration}
\item{ EXADJ }{Reason for Dose Adjustment}
\item{ EXSTDTC }{Start Date/Time of Treatment}
\item{ EXENDTC }{End Date/Time of Treatment}
\item{ EXSTDY }{Study Day of Start of Treatment}
\item{ EXENDY }{Study Day of End of Treatment}
\item{ EXSEQ }{Sequence Number}
\item{ ASTDT }{Analysis Start Date}
\item{ AENDT }{Analysis End Date}
\item{ EXDURD }{Duration of Treatment (Days)}
\item{ EXDOSU }{Dose Units}
\item{ VISITNUM }{Visit Number}
\item{ VISIT }{Visit Name}
\item{ VISITDY }{Planned Study Day of Visit}
\item{ EXPLDOS }{Planned Dose}
\item{ ASTDTM }{Analysis Start Datetime}
\item{ ASTDTF }{Analysis Start Date Imputation Flag}
\item{ ASTTMF }{Analysis Start Time Imputation Flag}
\item{ AENDTM }{Analysis End Datetime}
\item{ AENDTF }{Analysis End Date Imputation Flag}
\item{ AENTMF }{Analysis End Time Imputation Flag}
\item{ ASTDY }{Analysis Start Relative Day}
\item{ AENDY }{Analysis End Relative Day}
\item{ DOSEO }{Dose O}
\item{ PDOSEO }{PDose O}
\item{ PARAMCD }{Parameter Code}
\item{ AVAL }{Analysis Value}
\item{ AVALC }{Analysis Value (C)}
\item{ PARCAT1 }{Parameter Category 1}
\item{ PARAM }{Parameter}
\item{ PARAMN }{Parameter (N)}
\item{ AVALCAT1 }{Analysis Value Category 1}
}
}
\source{
Generated from admiral package (template ad_adex.R).
}
\usage{
adex
}
\description{
Exposure Analysis
}
\details{
Contains a set of 19 unique Parameter Codes and Parameters: \tabular{ll}{
\strong{PARAMCD} \tab \strong{PARAM} \cr
ADJ     \tab Dose adjusted during constant dosing interval             \cr
ADJAE   \tab Dose adjusted  due to AE during constant dosing interval  \cr
AVDDSE  \tab Average daily dose administered (mg/mg)                   \cr
DOSE    \tab Dose administered during constant dosing interval (mg)    \cr
DURD    \tab Study drug duration during constant dosing interval (days)\cr
PADJ    \tab Dose adjusted during W2-W24                               \cr
PADJAE  \tab Dose adjusted  in W2-W24 due to AE                        \cr
PAVDDSE \tab Average daily dose administered in W2-W24 (mg)            \cr
PDOSE   \tab Total dose administered in W2-W2 (mg)4                    \cr
PDOSINT \tab W2-24 dose intensity (\%)                                  \cr
PDURD   \tab Overall duration in W2-W24 (days)                         \cr
PLDOSE  \tab Planned dose during constant dosing interval (mg)         \cr
PPDOSE  \tab Total planned dose in W2-W24 (mg)                         \cr
TADJ    \tab Dose adjusted during study                                \cr
TADJAE  \tab Dose adjusted during study due to AE                      \cr
TDOSE   \tab Total dose administered (mg)                              \cr
TDOSINT \tab Overall dose intensity (\%)                                \cr
TDURD   \tab Overall duration (days)                                   \cr
TPDOSE  \tab Total planned dose (mg)
}
}
\examples{
data("adex")
}
\references{
None
}
\keyword{dataset}
\keyword{generic}
