# This file is automatically generated by data-raw/create_adams_data.R.
# For updating it please edit inst/extdata/adams-specs.xlsx and rerun create_adams_data.R.
# Manual edits are not recommended, as changes may be overwritten.
#'
#' @name adeg
#' @title Electrocardiogram Tests Analysis
#' @keywords dataset generic
#' @docType data
#' @format A data frame with 108 columns:
#'   \describe{
#'     \item{ STUDYID }{Study Identifier}
#'     \item{ USUBJID }{Unique Subject Identifier}
#'     \item{ SUBJID }{Subject Identifier for the Study}
#'     \item{ SITEID }{Study Site Identifier}
#'     \item{ COUNTRY }{Country}
#'     \item{ DOMAIN }{Domain Abbreviation}
#'     \item{ RFSTDTC }{Subject Reference Start Date/Time}
#'     \item{ RFENDTC }{Subject Reference End Date/Time}
#'     \item{ RFXSTDTC }{Date/Time of First Study Treatment}
#'     \item{ RFXENDTC }{Date/Time of Last Study Treatment}
#'     \item{ RFPENDTC }{Date/Time of End of Participation}
#'     \item{ SCRFDT }{Screen Failure Date}
#'     \item{ FRVDT }{Final Retrieval Visit Date}
#'     \item{ DTHDTC }{Date/Time of Death}
#'     \item{ DTHADY }{Relative Day of Death}
#'     \item{ DTHFL }{Subject Death Flag}
#'     \item{ LDDTHELD }{Elapsed Days from Last Dose to Death}
#'     \item{ LDDTHGR1 }{Last Dose to Death - Days Elapsed Grp 1}
#'     \item{ DTH30FL }{Death Within 30 Days of Last Trt Flag}
#'     \item{ DTHA30FL }{Death After 30 Days from Last Trt Flag}
#'     \item{ DTHDOM }{Domain for Date of Death Collection}
#'     \item{ DTHB30FL }{Death Within 30 Days of First Trt Flag}
#'     \item{ ASEQ }{Analysis Sequence Number}
#'     \item{ REGION1 }{Geographic Region 1}
#'     \item{ DMDTC }{Date/Time of Collection}
#'     \item{ DMDY }{Study Day of Collection}
#'     \item{ AGE }{Age}
#'     \item{ AGEU }{Age Units}
#'     \item{ AGEGR1 }{Pooled Age Group 1}
#'     \item{ SEX }{Sex}
#'     \item{ RACE }{Race}
#'     \item{ RACEGR1 }{Pooled Race Group 1}
#'     \item{ ETHNIC }{Ethnicity}
#'     \item{ SAFFL }{Safety Population Flag}
#'     \item{ ARM }{Description of Planned Arm}
#'     \item{ ARMCD }{Planned Arm Code}
#'     \item{ ACTARM }{Description of Actual Arm}
#'     \item{ ACTARMCD }{Actual Arm Code}
#'     \item{ TRTP }{Planned Treatment}
#'     \item{ TRTA }{Actual Treatment}
#'     \item{ TRT01P }{Planned Treatment for Period 01}
#'     \item{ TRT01A }{Actual Treatment for Period 01}
#'     \item{ TRTSDT }{Date of First Exposure to Treatment}
#'     \item{ TRTSDTM }{Datetime of First Exposure to Treatment}
#'     \item{ TRTSTMF }{Time of First Exposure Imput. Flag}
#'     \item{ TRTEDT }{Date of Last Exposure to Treatment}
#'     \item{ TRTEDTM }{Datetime of Last Exposure to Treatment}
#'     \item{ TRTETMF }{Time of Last Exposure Imput. Flag}
#'     \item{ EOSSTT }{End of Study Status}
#'     \item{ EOSDT }{End of Study Date}
#'     \item{ RFICDTC }{Date/Time of Informed Consent}
#'     \item{ RANDDT }{Date of Randomization}
#'     \item{ LSTALVDT }{Date Last Known Alive}
#'     \item{ TRTDURD }{Total Treatment Duration (Days)}
#'     \item{ DTHDT }{Date of Death}
#'     \item{ DTHDTF }{Date of Death Imputation Flag}
#'     \item{ DTHCAUS }{Cause of Death}
#'     \item{ DTHCGR1 }{Cause of Death Reason 1}
#'     \item{ ADT }{Analysis Date}
#'     \item{ ADTM }{Analysis Datetime}
#'     \item{ ADY }{Analysis Relative Day}
#'     \item{ ATMF }{Analysis Time Imputation Flag}
#'     \item{ AVISIT }{Analysis Visit}
#'     \item{ AVISITN }{Analysis Visit (N)}
#'     \item{ ATPT }{Analysis Timepoint}
#'     \item{ ATPTN }{Analysis Timepoint (N)}
#'     \item{ PARAM }{Parameter}
#'     \item{ PARAMCD }{Parameter Code}
#'     \item{ PARAMN }{Parameter (N)}
#'     \item{ AVAL }{Analysis Value}
#'     \item{ AVALC }{Analysis Value (C)}
#'     \item{ AVALCAT1 }{Analysis Value Category 1}
#'     \item{ AVALCA1N }{Analysis Value Category 1 (N)}
#'     \item{ BASE }{Baseline Value}
#'     \item{ BASEC }{Baseline Value (C)}
#'     \item{ BASETYPE }{Baseline Type}
#'     \item{ CHG }{Change from Baseline}
#'     \item{ CHGCAT1 }{Change from Baseline Category 1}
#'     \item{ CHGCAT1N }{Change from Baseline Category 1 (N)}
#'     \item{ PCHG }{Percent Change from Baseline}
#'     \item{ DTYPE }{Derivation Type}
#'     \item{ ANRIND }{Analysis Reference Range Indicator}
#'     \item{ BNRIND }{Baseline Reference Range Indicator}
#'     \item{ ANRLO }{Analysis Normal Range Lower Limit}
#'     \item{ ANRHI }{Analysis Normal Range Upper Limit}
#'     \item{ ABLFL }{Baseline Record Flag}
#'     \item{ ANL01FL }{Analysis Flag 01}
#'     \item{ ONTRTFL }{On Treatment Record Flag}
#'     \item{ EGSEQ }{Sequence Number}
#'     \item{ EGTESTCD }{ECG Test or Examination Short Name}
#'     \item{ EGTEST }{ECG Test or Examination Name}
#'     \item{ EGORRES }{Result or Finding in Original Units}
#'     \item{ EGORRESU }{Original Units}
#'     \item{ EGSTRESC }{Character Result/Finding in Std Format}
#'     \item{ EGSTRESN }{Numeric Result/Finding in Standard Units}
#'     \item{ EGSTRESU }{Standard Units}
#'     \item{ EGSTAT }{Completion Status}
#'     \item{ EGLOC }{Lead Location Used for Measurement}
#'     \item{ EGBLFL }{Baseline Flag}
#'     \item{ VISITNUM }{Visit Number}
#'     \item{ VISIT }{Visit Name}
#'     \item{ VISITDY }{Planned Study Day of Visit}
#'     \item{ EGDTC }{Date/Time of ECG}
#'     \item{ EGDY }{Study Day of ECG}
#'     \item{ EGTPT }{Planned Time Point Name}
#'     \item{ EGTPTNUM }{Planned Time Point Number}
#'     \item{ EGELTM }{Planned Elapsed Time from Time Point Ref}
#'     \item{ EGTPTREF }{Time Point Reference}
#'   }
#' @details Contains a set of 8 unique Parameter Codes and Parameters: \tabular{ll}{
#'   \strong{PARAMCD} \tab \strong{PARAM} \cr
#'   EGINTP \tab ECG Interpretation                                   \cr
#'   HR     \tab Heart Rate (beats/min)                               \cr
#'   QT     \tab QT Duration (ms)                                     \cr
#'   QTCBR  \tab QTcB - Bazett's Correction Formula Rederived (ms)    \cr
#'   QTCFR  \tab QTcF - Fridericia's Correction Formula Rederived (ms)\cr
#'   QTLCR  \tab QTlc - Sagie's Correction Formula Rederived (ms)     \cr
#'   RR     \tab RR Duration (ms)                                     \cr
#'   RRR    \tab RR Duration Rederived (ms)
#' }

#'
#' @source Generated from admiral package (template ad_adeg.R).
#' @references None
#'
#' @examples
#' data("adeg")
"adeg"
