% Generated by roxygen2 (disabled): do not edit by hand
\name{pgu.missings}
\alias{pgu.missings}
\title{pgu.missings}
\format{
\link[R6:R6Class]{R6::R6Class} object.
}
\description{
Detects and substitutes missing values from data set.
}
\details{
Detects missing values in the transformed and normalized data set.
This object is used by the shiny based gui and is not for use in individual R-scripts!
}
\author{
Sebastian Malkusch
}
\section{Active bindings}{
\if{html}{\out{<div class="r6-active-bindings">}}
\describe{
\item{\code{imputationParameter}}{Returns the instance variable imputationParameter (tibble::tibble)}
\item{\code{imputationSites}}{Returns the instance variable imputationSites (tibble::tibble)}
\item{\code{one_hot_df}}{Returns the positions of missings in one_hot encoding (tibble::tibble)}
\item{\code{amv}}{Returns the instance variable amv (numeric)}
}
\if{html}{\out{</div>}}
}

\section{Methods}{
The following public methods are available:

- `new()`: Creates a new pgu.missings object  
- `print()`: Prints instance variables
- `resetImputationParameter()`: Resets imputation parameters
- `featureIdx()`: Get feature position
- `filterFeatures()`: Filter features with missings
- `gatherMeasurements()`, `gatherMissings()`, `gatherExistings()`, `gatherFractionOfMissings()`: Gather missing value statistics
- `gatherImputationStatistics()`: Collect imputation statistics
- `one_hot()`: Create one-hot encoding of missings
- `detectImputationSites()`: Detect missing value positions
- `imputationSiteDistribution()`: Get missing value distribution
- `imputationSiteHeatMap()`: Create missing value heatmap
- `clone()`: Clone the object
}
\seealso{
Other pguIMP classes: \code{\link{pgu.limitsOfQuantification}}
}
\keyword{datasets}
