% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pguExporter.R
\name{pgu.exporter}
\alias{pgu.exporter}
\title{pgu.exporter}
\format{
[R6::R6Class] object.
}
\description{
A class that writes the results of the pguIMP analysis to an Excel file.
}
\details{
Creates a download file name and saves a list of tibbles to an Excel file.
Each tibble is written to a separate sheet.
This object is used by the shiny based gui and is not for use in individual R-scripts!
}
\author{
Sebastian Malkusch
}
\section{Active bindings}{
\if{html}{\out{<div class="r6-active-bindings">}}
\describe{
\item{\code{fileName}}{Returns the fileName.
(character)}

\item{\code{setFileName}}{Set the fileName.
(character)}

\item{\code{suffix}}{Returns the file suffix.
(character)}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-pgu.exporter-new}{\code{pgu.exporter$new()}}
\item \href{#method-pgu.exporter-finalize}{\code{pgu.exporter$finalize()}}
\item \href{#method-pgu.exporter-print}{\code{pgu.exporter$print()}}
\item \href{#method-pgu.exporter-extractSuffix}{\code{pgu.exporter$extractSuffix()}}
\item \href{#method-pgu.exporter-writeDataToExcel}{\code{pgu.exporter$writeDataToExcel()}}
\item \href{#method-pgu.exporter-clone}{\code{pgu.exporter$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-pgu.exporter-new"></a>}}
\if{latex}{\out{\hypertarget{method-pgu.exporter-new}{}}}
\subsection{Method \code{new()}}{
Creates and returns a new `pgu.exporter` object.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{pgu.exporter$new()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
A new `pgu.exporter` object.
(pguIMP::pgu.exporter)
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-pgu.exporter-finalize"></a>}}
\if{latex}{\out{\hypertarget{method-pgu.exporter-finalize}{}}}
\subsection{Method \code{finalize()}}{
Clears the heap and
indicates if instance of `pgu.exporter` is removed from heap.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{pgu.exporter$finalize()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-pgu.exporter-print"></a>}}
\if{latex}{\out{\hypertarget{method-pgu.exporter-print}{}}}
\subsection{Method \code{print()}}{
Prints instance variables of a `pgu.exporter` object.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{pgu.exporter$print()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
string
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-pgu.exporter-extractSuffix"></a>}}
\if{latex}{\out{\hypertarget{method-pgu.exporter-extractSuffix}{}}}
\subsection{Method \code{extractSuffix()}}{
extracts the suffix from the fileName
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{pgu.exporter$extractSuffix()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-pgu.exporter-writeDataToExcel"></a>}}
\if{latex}{\out{\hypertarget{method-pgu.exporter-writeDataToExcel}{}}}
\subsection{Method \code{writeDataToExcel()}}{
writes tibble to an excel file of the name fileName.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{pgu.exporter$writeDataToExcel(obj = "list")}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{obj}}{A tibble or list of tibble.
If obj is a list, each member will be written to a seperate sheet.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-pgu.exporter-clone"></a>}}
\if{latex}{\out{\hypertarget{method-pgu.exporter-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{pgu.exporter$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
