% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pguDelegate.R
\name{pgu.delegate}
\alias{pgu.delegate}
\title{pgu.delegate}
\format{
\link[R6:R6Class]{R6::R6Class} object.
}
\description{
Manages the communication between the shiny gui layer and the classes of the pguIMP package
}
\details{
Comprises all needed classes from the pguIMP package and manages the communication between the gui and the analysis.
This object is used by the shiny based gui and is not for use in individual R-scripts!
}
\author{
Sebastian Malkusch
}
\section{Active bindings}{
\if{html}{\out{<div class="r6-active-bindings">}}
\describe{
\item{\code{status}}{Returns the instance variable status
(pguIMP::pgu.status)}

\item{\code{fileName}}{Returns the instance variable fileName
(pguIMP::pgu.file)}

\item{\code{loqFileName}}{Returns the instance variable loqFileName
(pguIMP::pgu.file)}

\item{\code{rawData}}{Returns the instance variable rawData
(pguIMP::pgu.data)}

\item{\code{filterSet}}{Returns the instance variable filterSet
(pguIMP::pgu.filter)}

\item{\code{filteredData}}{Returns the instance variable filteredData
(pguIMP::pgu.data)}

\item{\code{loq}}{Returns the instance variable loq
(pguIMP::pgu.limitsOfQuantification)}

\item{\code{loqMutatedData}}{Returns the instance variable loqMutatedData
(pguIMP::pgu.data)}

\item{\code{explorer}}{Returns the instance variable explorer
(pguIMP::pgu.explorer)}

\item{\code{optimizer}}{Returns the instance variable optimizer
(pguIMP::pgu.optimizer)}

\item{\code{transformator}}{Returns the instance variable transformator
(pguIMP::pgu.transformator)}

\item{\code{model}}{Returns the instance variable model
(pguIMP::pgu.model)}

\item{\code{transformedData}}{Returns the instance variable transformedData
(pguIMP::pgu.data)}

\item{\code{featureModel}}{Returns the instance variable featureModel
(pguIMP::pgu.normDist)}

\item{\code{normalizer}}{Returns the instance variable normalizer
(pguIMP::pgu.normalizer)}

\item{\code{normalizedData}}{Returns the instance variable normalizedData
(pguIMP::pgu.data)}

\item{\code{missings}}{Returns the instance variable missings
(pguIMP::pgu.missings)}

\item{\code{missingsCharacterizer}}{Returns the instance variable missingsCharacterizer
(pguIMP::pgu.missingsCharacterizer)}

\item{\code{outliers}}{Returns the instance variable outlierd
(pguIMP::pgu.outliers)}

\item{\code{imputer}}{Returns the instance variable imputer
(pguIMP::pgu.imputation)}

\item{\code{imputedData}}{Returns the instance variable imputedData
(pguIMP::pgu.data)}

\item{\code{cleanedData}}{Returns the instance variable cleanedData
(pguIMP::pgu.data)}

\item{\code{validator}}{Returns the instance variable validator
(pguIMP::pgu.validator)}

\item{\code{corrValidator}}{Returns the instance variable corrValidator
(pguIMP::pgu.corrValidator)}

\item{\code{exporter}}{Returns the instance variable exporter
(pguIMP::pgu.exporter)}

\item{\code{reporter}}{Returns the instance variable reporter
(pguIMP::pgu.reporter)}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-new}{\code{pgu.delegate$new()}}
\item \href{#method-print}{\code{pgu.delegate$print()}}
\item \href{#method-update_import_gui}{\code{pgu.delegate$update_import_gui()}}
\item \href{#method-query_data}{\code{pgu.delegate$query_data()}}
\item \href{#method-import_data}{\code{pgu.delegate$import_data()}}
\item \href{#method-update_import_data_Types_tbl}{\code{pgu.delegate$update_import_data_Types_tbl()}}
\item \href{#method-update_import_data_statistics_tbl}{\code{pgu.delegate$update_import_data_statistics_tbl()}}
\item \href{#method-update_import_missings_statistics_tbl}{\code{pgu.delegate$update_import_missings_statistics_tbl()}}
\item \href{#method-update_filter_select_tbl}{\code{pgu.delegate$update_filter_select_tbl()}}
\item \href{#method-update_filter}{\code{pgu.delegate$update_filter()}}
\item \href{#method-update_filter_inverse}{\code{pgu.delegate$update_filter_inverse()}}
\item \href{#method-reset_filter}{\code{pgu.delegate$reset_filter()}}
\item \href{#method-filter_data}{\code{pgu.delegate$filter_data()}}
\item \href{#method-update_filter_statistics_tbl}{\code{pgu.delegate$update_filter_statistics_tbl()}}
\item \href{#method-update_filter_missings_tbl}{\code{pgu.delegate$update_filter_missings_tbl()}}
\item \href{#method-update_exploration_gui}{\code{pgu.delegate$update_exploration_gui()}}
\item \href{#method-update_exploration_abscissa}{\code{pgu.delegate$update_exploration_abscissa()}}
\item \href{#method-update_exploration_ordinate}{\code{pgu.delegate$update_exploration_ordinate()}}
\item \href{#method-update_exploration_graphic}{\code{pgu.delegate$update_exploration_graphic()}}
\item \href{#method-update_exploration_abscissa_graphic}{\code{pgu.delegate$update_exploration_abscissa_graphic()}}
\item \href{#method-update_exploration_ordinate_graphic}{\code{pgu.delegate$update_exploration_ordinate_graphic()}}
\item \href{#method-update_exploration_abscissa_table}{\code{pgu.delegate$update_exploration_abscissa_table()}}
\item \href{#method-update_exploration_ordinate_table}{\code{pgu.delegate$update_exploration_ordinate_table()}}
\item \href{#method-reset_loq_values}{\code{pgu.delegate$reset_loq_values()}}
\item \href{#method-update_loq_upload_gui}{\code{pgu.delegate$update_loq_upload_gui()}}
\item \href{#method-query_loq}{\code{pgu.delegate$query_loq()}}
\item \href{#method-import_loq}{\code{pgu.delegate$import_loq()}}
\item \href{#method-update_loq_define_gui}{\code{pgu.delegate$update_loq_define_gui()}}
\item \href{#method-update_loq_define_feature}{\code{pgu.delegate$update_loq_define_feature()}}
\item \href{#method-update_loq_define_lloq}{\code{pgu.delegate$update_loq_define_lloq()}}
\item \href{#method-update_loq_define_uloq}{\code{pgu.delegate$update_loq_define_uloq()}}
\item \href{#method-update_loq_define_table}{\code{pgu.delegate$update_loq_define_table()}}
\item \href{#method-update_loq_define_menu}{\code{pgu.delegate$update_loq_define_menu()}}
\item \href{#method-set_loq_define_values}{\code{pgu.delegate$set_loq_define_values()}}
\item \href{#method-set_loq_define_values_globally}{\code{pgu.delegate$set_loq_define_values_globally()}}
\item \href{#method-update_loq_detect_gui}{\code{pgu.delegate$update_loq_detect_gui()}}
\item \href{#method-update_loq_na_handling}{\code{pgu.delegate$update_loq_na_handling()}}
\item \href{#method-init_detect_loq}{\code{pgu.delegate$init_detect_loq()}}
\item \href{#method-detect_loq}{\code{pgu.delegate$detect_loq()}}
\item \href{#method-update_loq_detect_statistics_tbl}{\code{pgu.delegate$update_loq_detect_statistics_tbl()}}
\item \href{#method-update_loq_detect_outlier_tbl}{\code{pgu.delegate$update_loq_detect_outlier_tbl()}}
\item \href{#method-update_loq_detect_statistics_graphic}{\code{pgu.delegate$update_loq_detect_statistics_graphic()}}
\item \href{#method-update_loq_detect_attribute_graphic}{\code{pgu.delegate$update_loq_detect_attribute_graphic()}}
\item \href{#method-update_loq_detect_attribute_tbl}{\code{pgu.delegate$update_loq_detect_attribute_tbl()}}
\item \href{#method-update_loq_mutate_gui}{\code{pgu.delegate$update_loq_mutate_gui()}}
\item \href{#method-update_lloq_substitute}{\code{pgu.delegate$update_lloq_substitute()}}
\item \href{#method-update_uloq_substitute}{\code{pgu.delegate$update_uloq_substitute()}}
\item \href{#method-init_mutate_loq}{\code{pgu.delegate$init_mutate_loq()}}
\item \href{#method-mutate_loq}{\code{pgu.delegate$mutate_loq()}}
\item \href{#method-update_loq_mutate_data_tbl}{\code{pgu.delegate$update_loq_mutate_data_tbl()}}
\item \href{#method-update_loq_mutate_statistics_graphic}{\code{pgu.delegate$update_loq_mutate_statistics_graphic()}}
\item \href{#method-update_loq_mutate_attribute_graphic}{\code{pgu.delegate$update_loq_mutate_attribute_graphic()}}
\item \href{#method-init_loq_mutate_attribute_tbl}{\code{pgu.delegate$init_loq_mutate_attribute_tbl()}}
\item \href{#method-update_loq_mutate_attribute_tbl}{\code{pgu.delegate$update_loq_mutate_attribute_tbl()}}
\item \href{#method-optimizeTrafoParameter}{\code{pgu.delegate$optimizeTrafoParameter()}}
\item \href{#method-updateDetectedTrafoTypes}{\code{pgu.delegate$updateDetectedTrafoTypes()}}
\item \href{#method-updateDetectedTrafoParameter}{\code{pgu.delegate$updateDetectedTrafoParameter()}}
\item \href{#method-updateTrafoDetectGui}{\code{pgu.delegate$updateTrafoDetectGui()}}
\item \href{#method-updateTrafoMutateFeature}{\code{pgu.delegate$updateTrafoMutateFeature()}}
\item \href{#method-updateTrafoMutateType}{\code{pgu.delegate$updateTrafoMutateType()}}
\item \href{#method-updateTrafoMutateLambda}{\code{pgu.delegate$updateTrafoMutateLambda()}}
\item \href{#method-updateTrafoMutateMirror}{\code{pgu.delegate$updateTrafoMutateMirror()}}
\item \href{#method-resetTrafoMutateGui}{\code{pgu.delegate$resetTrafoMutateGui()}}
\item \href{#method-updateTrafoMutateGui}{\code{pgu.delegate$updateTrafoMutateGui()}}
\item \href{#method-trafoMutateFit}{\code{pgu.delegate$trafoMutateFit()}}
\item \href{#method-trafoMutateGlobal}{\code{pgu.delegate$trafoMutateGlobal()}}
\item \href{#method-trafoMutateFeature}{\code{pgu.delegate$trafoMutateFeature()}}
\item \href{#method-updateTrafoMutateFeatureGraphic}{\code{pgu.delegate$updateTrafoMutateFeatureGraphic()}}
\item \href{#method-updateTrafoMutateFeatureParameterTbl}{\code{pgu.delegate$updateTrafoMutateFeatureParameterTbl()}}
\item \href{#method-updateTrafoMutateFeatureQualityTbl}{\code{pgu.delegate$updateTrafoMutateFeatureQualityTbl()}}
\item \href{#method-updateTrafoMutateGlobalParameterTbl}{\code{pgu.delegate$updateTrafoMutateGlobalParameterTbl()}}
\item \href{#method-updateTrafoMutateGlobalModelTbl}{\code{pgu.delegate$updateTrafoMutateGlobalModelTbl()}}
\item \href{#method-updateTrafoMutateGlobalQualityTbl}{\code{pgu.delegate$updateTrafoMutateGlobalQualityTbl()}}
\item \href{#method-updateTrafoMutateGlobalTestsTbl}{\code{pgu.delegate$updateTrafoMutateGlobalTestsTbl()}}
\item \href{#method-updateTrafoMutateGlobalDataTbl}{\code{pgu.delegate$updateTrafoMutateGlobalDataTbl()}}
\item \href{#method-updateTrafoNormFeature}{\code{pgu.delegate$updateTrafoNormFeature()}}
\item \href{#method-updateTrafoNormMethod}{\code{pgu.delegate$updateTrafoNormMethod()}}
\item \href{#method-updateTrafoNormGui}{\code{pgu.delegate$updateTrafoNormGui()}}
\item \href{#method-trafoNormMutate}{\code{pgu.delegate$trafoNormMutate()}}
\item \href{#method-updateTrafoNormFeatureGraphic}{\code{pgu.delegate$updateTrafoNormFeatureGraphic()}}
\item \href{#method-resetTrafoNormGui}{\code{pgu.delegate$resetTrafoNormGui()}}
\item \href{#method-updateTrafoNormFeatureStatisticsTbl}{\code{pgu.delegate$updateTrafoNormFeatureStatisticsTbl()}}
\item \href{#method-updateTrafoNormStatisticsTbl}{\code{pgu.delegate$updateTrafoNormStatisticsTbl()}}
\item \href{#method-updateTrafoNormParameterTbl}{\code{pgu.delegate$updateTrafoNormParameterTbl()}}
\item \href{#method-updateTrafoNormDataTbl}{\code{pgu.delegate$updateTrafoNormDataTbl()}}
\item \href{#method-imputeMissingsAnalyze}{\code{pgu.delegate$imputeMissingsAnalyze()}}
\item \href{#method-updateImputeMissingsGraphic}{\code{pgu.delegate$updateImputeMissingsGraphic()}}
\item \href{#method-updateImputeMissingsStatisticsTbl}{\code{pgu.delegate$updateImputeMissingsStatisticsTbl()}}
\item \href{#method-updateImputeMissingsDistributionTbl}{\code{pgu.delegate$updateImputeMissingsDistributionTbl()}}
\item \href{#method-updateImputeMissingCharacteristicsGraphic}{\code{pgu.delegate$updateImputeMissingCharacteristicsGraphic()}}
\item \href{#method-updateImputeMissingsCharacteristicsTbl}{\code{pgu.delegate$updateImputeMissingsCharacteristicsTbl()}}
\item \href{#method-updateImputeMissingsDetailTbl}{\code{pgu.delegate$updateImputeMissingsDetailTbl()}}
\item \href{#method-updateImputeOutliersMethod}{\code{pgu.delegate$updateImputeOutliersMethod()}}
\item \href{#method-updateImputeOutliersFeature}{\code{pgu.delegate$updateImputeOutliersFeature()}}
\item \href{#method-updateImputeOutliersAlpha}{\code{pgu.delegate$updateImputeOutliersAlpha()}}
\item \href{#method-updateImputeOutliersEpsilon}{\code{pgu.delegate$updateImputeOutliersEpsilon()}}
\item \href{#method-updateImputeOutliersMinSamples}{\code{pgu.delegate$updateImputeOutliersMinSamples()}}
\item \href{#method-updateImputeOutliersGamma}{\code{pgu.delegate$updateImputeOutliersGamma()}}
\item \href{#method-updateImputeOutliersNu}{\code{pgu.delegate$updateImputeOutliersNu()}}
\item \href{#method-updateImputeOutliersCutoff}{\code{pgu.delegate$updateImputeOutliersCutoff()}}
\item \href{#method-updateImputeOutliersK}{\code{pgu.delegate$updateImputeOutliersK()}}
\item \href{#method-updateImputeOutliersSeed}{\code{pgu.delegate$updateImputeOutliersSeed()}}
\item \href{#method-updateImputeOutliersGui}{\code{pgu.delegate$updateImputeOutliersGui()}}
\item \href{#method-resetImputeOutliersGui}{\code{pgu.delegate$resetImputeOutliersGui()}}
\item \href{#method-imputeOutliersDetect}{\code{pgu.delegate$imputeOutliersDetect()}}
\item \href{#method-updateImputeOutliersGraphic}{\code{pgu.delegate$updateImputeOutliersGraphic()}}
\item \href{#method-updateImputeOutliersFeatureGraphic}{\code{pgu.delegate$updateImputeOutliersFeatureGraphic()}}
\item \href{#method-updateImputeOutliersFeatureTbl}{\code{pgu.delegate$updateImputeOutliersFeatureTbl()}}
\item \href{#method-updateImputeOutliersStatisticsTbl}{\code{pgu.delegate$updateImputeOutliersStatisticsTbl()}}
\item \href{#method-updateImputeOutliersDetailTbl}{\code{pgu.delegate$updateImputeOutliersDetailTbl()}}
\item \href{#method-updateImputeMutateFeature}{\code{pgu.delegate$updateImputeMutateFeature()}}
\item \href{#method-updateImputeMutateMethod}{\code{pgu.delegate$updateImputeMutateMethod()}}
\item \href{#method-updateImputeMutateNNeighbors}{\code{pgu.delegate$updateImputeMutateNNeighbors()}}
\item \href{#method-updateImputeMutatePredFrac}{\code{pgu.delegate$updateImputeMutatePredFrac()}}
\item \href{#method-updateImputeMutateOutfluxThr}{\code{pgu.delegate$updateImputeMutateOutfluxThr()}}
\item \href{#method-updateImputeMutateSeed}{\code{pgu.delegate$updateImputeMutateSeed()}}
\item \href{#method-updateImputeMutateIterations}{\code{pgu.delegate$updateImputeMutateIterations()}}
\item \href{#method-updateImputeMutateGui}{\code{pgu.delegate$updateImputeMutateGui()}}
\item \href{#method-resetImputeMutateGui}{\code{pgu.delegate$resetImputeMutateGui()}}
\item \href{#method-imputeMutateMutate}{\code{pgu.delegate$imputeMutateMutate()}}
\item \href{#method-updateImputeFluxGraphic}{\code{pgu.delegate$updateImputeFluxGraphic()}}
\item \href{#method-updateImputeMutateGraphic}{\code{pgu.delegate$updateImputeMutateGraphic()}}
\item \href{#method-updateImputeMutateStatisticsTbl}{\code{pgu.delegate$updateImputeMutateStatisticsTbl()}}
\item \href{#method-updateImputeMutateDistributionTbl}{\code{pgu.delegate$updateImputeMutateDistributionTbl()}}
\item \href{#method-updateImputeMutateFeatureDetailGraphic}{\code{pgu.delegate$updateImputeMutateFeatureDetailGraphic()}}
\item \href{#method-updateImputeMutateFeatureDetailTbl}{\code{pgu.delegate$updateImputeMutateFeatureDetailTbl()}}
\item \href{#method-updateImputeMutateDetailTbl}{\code{pgu.delegate$updateImputeMutateDetailTbl()}}
\item \href{#method-updateImputeMutateDataTbl}{\code{pgu.delegate$updateImputeMutateDataTbl()}}
\item \href{#method-validate}{\code{pgu.delegate$validate()}}
\item \href{#method-updateAnalysisValidationGui}{\code{pgu.delegate$updateAnalysisValidationGui()}}
\item \href{#method-updateAnalysisValidationGraphic}{\code{pgu.delegate$updateAnalysisValidationGraphic()}}
\item \href{#method-updateAnalysisValidationTestTbl}{\code{pgu.delegate$updateAnalysisValidationTestTbl()}}
\item \href{#method-updateCentralMomentsOrgTbl}{\code{pgu.delegate$updateCentralMomentsOrgTbl()}}
\item \href{#method-updateCentralMomentsImpTbl}{\code{pgu.delegate$updateCentralMomentsImpTbl()}}
\item \href{#method-updateCentralMomentsDeltaTbl}{\code{pgu.delegate$updateCentralMomentsDeltaTbl()}}
\item \href{#method-updateCorrelationValidationScatterGraphic}{\code{pgu.delegate$updateCorrelationValidationScatterGraphic()}}
\item \href{#method-updateCorrelationValidationBoxPlotGraphic}{\code{pgu.delegate$updateCorrelationValidationBoxPlotGraphic()}}
\item \href{#method-updateCorrelationValidationDeviationTbl}{\code{pgu.delegate$updateCorrelationValidationDeviationTbl()}}
\item \href{#method-updateCorrelationValidationDataTbl}{\code{pgu.delegate$updateCorrelationValidationDataTbl()}}
\item \href{#method-exportFileName}{\code{pgu.delegate$exportFileName()}}
\item \href{#method-exportData}{\code{pgu.delegate$exportData()}}
\item \href{#method-reportFileName}{\code{pgu.delegate$reportFileName()}}
\item \href{#method-writeReport}{\code{pgu.delegate$writeReport()}}
\item \href{#method-hide_outdated_results}{\code{pgu.delegate$hide_outdated_results()}}
\item \href{#method-update_help_html}{\code{pgu.delegate$update_help_html()}}
\item \href{#method-clone}{\code{pgu.delegate$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-new"></a>}}
\if{latex}{\out{\hypertarget{method-new}{}}}
\subsection{Method \code{new()}}{
Clears the heap and
indicates that instance of \code{pgu.delegate} is removed from heap.


Creates and returns a new \code{pgu.delegate} object.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{pgu.delegate$new(data = "tbl_df")}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{data}}{The data to be analyzed.
(tibble::tibble)}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A new \code{pgu.delegate} object.
(pguIMP::pgu.delegate)
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-print"></a>}}
\if{latex}{\out{\hypertarget{method-print}{}}}
\subsection{Method \code{print()}}{
Prints instance variables of a \code{pgu.delegate} object.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{pgu.delegate$print()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
string
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-update_import_gui"></a>}}
\if{latex}{\out{\hypertarget{method-update_import_gui}{}}}
\subsection{Method \code{update_import_gui()}}{
Updates the import gui
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{pgu.delegate$update_import_gui(input, output, session)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{input}}{Pointer to shiny input}

\item{\code{output}}{Pointer to shiny output}

\item{\code{session}}{Pointer to shiny session}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-query_data"></a>}}
\if{latex}{\out{\hypertarget{method-query_data}{}}}
\subsection{Method \code{query_data()}}{
Manages the data upload to the R server.
Updates the instance class status.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{pgu.delegate$query_data(input, output, session)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{input}}{Pointer to shiny input}

\item{\code{output}}{Pointer to shiny output}

\item{\code{session}}{Pointer to shiny session}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-import_data"></a>}}
\if{latex}{\out{\hypertarget{method-import_data}{}}}
\subsection{Method \code{import_data()}}{
Imports uploaded data from the R server into the instance variable rawData.
Updates the instance class status.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{pgu.delegate$import_data(input, output, session)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{input}}{Pointer to shiny input}

\item{\code{output}}{Pointer to shiny output}

\item{\code{session}}{Pointer to shiny session}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-update_import_data_Types_tbl"></a>}}
\if{latex}{\out{\hypertarget{method-update_import_data_Types_tbl}{}}}
\subsection{Method \code{update_import_data_Types_tbl()}}{
Updates the tbl.importDataTypes table.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{pgu.delegate$update_import_data_Types_tbl(input, output, session)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{input}}{Pointer to shiny input}

\item{\code{output}}{Pointer to shiny output}

\item{\code{session}}{Pointer to shiny session}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-update_import_data_statistics_tbl"></a>}}
\if{latex}{\out{\hypertarget{method-update_import_data_statistics_tbl}{}}}
\subsection{Method \code{update_import_data_statistics_tbl()}}{
Updates the tbl.importDataStatistics table.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{pgu.delegate$update_import_data_statistics_tbl(input, output, session)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{input}}{Pointer to shiny input}

\item{\code{output}}{Pointer to shiny output}

\item{\code{session}}{Pointer to shiny session}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-update_import_missings_statistics_tbl"></a>}}
\if{latex}{\out{\hypertarget{method-update_import_missings_statistics_tbl}{}}}
\subsection{Method \code{update_import_missings_statistics_tbl()}}{
Updates the tbl.importMissingsStatistics table.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{pgu.delegate$update_import_missings_statistics_tbl(input, output, session)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{input}}{Pointer to shiny input}

\item{\code{output}}{Pointer to shiny output}

\item{\code{session}}{Pointer to shiny session}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-update_filter_select_tbl"></a>}}
\if{latex}{\out{\hypertarget{method-update_filter_select_tbl}{}}}
\subsection{Method \code{update_filter_select_tbl()}}{
Updates the tbl.filter table.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{pgu.delegate$update_filter_select_tbl(input, output, session)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{input}}{Pointer to shiny input}

\item{\code{output}}{Pointer to shiny output}

\item{\code{session}}{Pointer to shiny session}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-update_filter"></a>}}
\if{latex}{\out{\hypertarget{method-update_filter}{}}}
\subsection{Method \code{update_filter()}}{
Queries the filter parameters selected by the user in the gui
and stores them in the instance variable filterSet.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{pgu.delegate$update_filter(input, output, session)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{input}}{Pointer to shiny input}

\item{\code{output}}{Pointer to shiny output}

\item{\code{session}}{Pointer to shiny session}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-update_filter_inverse"></a>}}
\if{latex}{\out{\hypertarget{method-update_filter_inverse}{}}}
\subsection{Method \code{update_filter_inverse()}}{
Queries the filter parameters selected by the user in the gui
inverts them
and stores them in the instance variable filterSet.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{pgu.delegate$update_filter_inverse(input, output, session)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{input}}{Pointer to shiny input}

\item{\code{output}}{Pointer to shiny output}

\item{\code{session}}{Pointer to shiny session}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-reset_filter"></a>}}
\if{latex}{\out{\hypertarget{method-reset_filter}{}}}
\subsection{Method \code{reset_filter()}}{
Generates a filter set that selects the whole data frame.
Stores them in the instance variable filterSet.
Updates the gui.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{pgu.delegate$reset_filter(input, output, session)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{input}}{Pointer to shiny input}

\item{\code{output}}{Pointer to shiny output}

\item{\code{session}}{Pointer to shiny session}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-filter_data"></a>}}
\if{latex}{\out{\hypertarget{method-filter_data}{}}}
\subsection{Method \code{filter_data()}}{
Filters the data corresponding to the user defined parameters stored in the instance variable filterSet.
Results are stored in the instance variables filteredData and filteredMetadata.
Updated the instance variable filterSet.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{pgu.delegate$filter_data(input, output, session)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{input}}{Pointer to shiny input}

\item{\code{output}}{Pointer to shiny output}

\item{\code{session}}{Pointer to shiny session}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-update_filter_statistics_tbl"></a>}}
\if{latex}{\out{\hypertarget{method-update_filter_statistics_tbl}{}}}
\subsection{Method \code{update_filter_statistics_tbl()}}{
Updates the tbl.filterStatistics table.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{pgu.delegate$update_filter_statistics_tbl(input, output, session)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{input}}{Pointer to shiny input}

\item{\code{output}}{Pointer to shiny output}

\item{\code{session}}{Pointer to shiny session}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-update_filter_missings_tbl"></a>}}
\if{latex}{\out{\hypertarget{method-update_filter_missings_tbl}{}}}
\subsection{Method \code{update_filter_missings_tbl()}}{
Updates the tbl.filterMissings table.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{pgu.delegate$update_filter_missings_tbl(input, output, session)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{input}}{Pointer to shiny input}

\item{\code{output}}{Pointer to shiny output}

\item{\code{session}}{Pointer to shiny session}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-update_exploration_gui"></a>}}
\if{latex}{\out{\hypertarget{method-update_exploration_gui}{}}}
\subsection{Method \code{update_exploration_gui()}}{
Updates the gui.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{pgu.delegate$update_exploration_gui(input, output, session)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{input}}{Pointer to shiny input}

\item{\code{output}}{Pointer to shiny output}

\item{\code{session}}{Pointer to shiny session}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-update_exploration_abscissa"></a>}}
\if{latex}{\out{\hypertarget{method-update_exploration_abscissa}{}}}
\subsection{Method \code{update_exploration_abscissa()}}{
Transfers the information oabout the selected abscissa attribute to the explorer class.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{pgu.delegate$update_exploration_abscissa(input, output, session)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{input}}{Pointer to shiny input}

\item{\code{output}}{Pointer to shiny output}

\item{\code{session}}{Pointer to shiny session}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-update_exploration_ordinate"></a>}}
\if{latex}{\out{\hypertarget{method-update_exploration_ordinate}{}}}
\subsection{Method \code{update_exploration_ordinate()}}{
Transfers the information oabout the selected ordinate attribute to the explorer class.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{pgu.delegate$update_exploration_ordinate(input, output, session)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{input}}{Pointer to shiny input}

\item{\code{output}}{Pointer to shiny output}

\item{\code{session}}{Pointer to shiny session}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-update_exploration_graphic"></a>}}
\if{latex}{\out{\hypertarget{method-update_exploration_graphic}{}}}
\subsection{Method \code{update_exploration_graphic()}}{
Updates the exploration abscissa vs. ordinate scatter plot
corresponding to the respective user defined attributes.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{pgu.delegate$update_exploration_graphic(input, output, session)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{input}}{Pointer to shiny input}

\item{\code{output}}{Pointer to shiny output}

\item{\code{session}}{Pointer to shiny session}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-update_exploration_abscissa_graphic"></a>}}
\if{latex}{\out{\hypertarget{method-update_exploration_abscissa_graphic}{}}}
\subsection{Method \code{update_exploration_abscissa_graphic()}}{
Updates the abscissa compound plot
corresponding to the respective user defined attributes.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{pgu.delegate$update_exploration_abscissa_graphic(input, output, session)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{input}}{Pointer to shiny input}

\item{\code{output}}{Pointer to shiny output}

\item{\code{session}}{Pointer to shiny session}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-update_exploration_ordinate_graphic"></a>}}
\if{latex}{\out{\hypertarget{method-update_exploration_ordinate_graphic}{}}}
\subsection{Method \code{update_exploration_ordinate_graphic()}}{
Updates the ordinate compound plot
corresponding to the respective user defined attributes.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{pgu.delegate$update_exploration_ordinate_graphic(input, output, session)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{input}}{Pointer to shiny input}

\item{\code{output}}{Pointer to shiny output}

\item{\code{session}}{Pointer to shiny session}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-update_exploration_abscissa_table"></a>}}
\if{latex}{\out{\hypertarget{method-update_exploration_abscissa_table}{}}}
\subsection{Method \code{update_exploration_abscissa_table()}}{
Updates the numerical abscissa analysis table.
corresponding to the respective user defined attributes.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{pgu.delegate$update_exploration_abscissa_table(input, output, session)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{input}}{Pointer to shiny input}

\item{\code{output}}{Pointer to shiny output}

\item{\code{session}}{Pointer to shiny session}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-update_exploration_ordinate_table"></a>}}
\if{latex}{\out{\hypertarget{method-update_exploration_ordinate_table}{}}}
\subsection{Method \code{update_exploration_ordinate_table()}}{
Updates the numerical ordinate analysis table.
corresponding to the respective user defined attributes.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{pgu.delegate$update_exploration_ordinate_table(input, output, session)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{input}}{Pointer to shiny input}

\item{\code{output}}{Pointer to shiny output}

\item{\code{session}}{Pointer to shiny session}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-reset_loq_values"></a>}}
\if{latex}{\out{\hypertarget{method-reset_loq_values}{}}}
\subsection{Method \code{reset_loq_values()}}{
Initializes the LOQ object after filtering.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{pgu.delegate$reset_loq_values(input, output, session)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{input}}{Pointer to shiny input}

\item{\code{output}}{Pointer to shiny output}

\item{\code{session}}{Pointer to shiny session}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-update_loq_upload_gui"></a>}}
\if{latex}{\out{\hypertarget{method-update_loq_upload_gui}{}}}
\subsection{Method \code{update_loq_upload_gui()}}{
Updates the gui.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{pgu.delegate$update_loq_upload_gui(input, output, session)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{input}}{Pointer to shiny input}

\item{\code{output}}{Pointer to shiny output}

\item{\code{session}}{Pointer to shiny session}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-query_loq"></a>}}
\if{latex}{\out{\hypertarget{method-query_loq}{}}}
\subsection{Method \code{query_loq()}}{
Manages the loq data upload to the R server.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{pgu.delegate$query_loq(input, output, session)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{input}}{Pointer to shiny input}

\item{\code{output}}{Pointer to shiny output}

\item{\code{session}}{Pointer to shiny session}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-import_loq"></a>}}
\if{latex}{\out{\hypertarget{method-import_loq}{}}}
\subsection{Method \code{import_loq()}}{
Imports the loq data upload to the R server.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{pgu.delegate$import_loq(input, output, session)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{input}}{Pointer to shiny input}

\item{\code{output}}{Pointer to shiny output}

\item{\code{session}}{Pointer to shiny session}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-update_loq_define_gui"></a>}}
\if{latex}{\out{\hypertarget{method-update_loq_define_gui}{}}}
\subsection{Method \code{update_loq_define_gui()}}{
Updates the gui.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{pgu.delegate$update_loq_define_gui(input, output, session)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{input}}{Pointer to shiny input}

\item{\code{output}}{Pointer to shiny output}

\item{\code{session}}{Pointer to shiny session}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-update_loq_define_feature"></a>}}
\if{latex}{\out{\hypertarget{method-update_loq_define_feature}{}}}
\subsection{Method \code{update_loq_define_feature()}}{
Updates the gui.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{pgu.delegate$update_loq_define_feature(input, output, session)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{input}}{Pointer to shiny input}

\item{\code{output}}{Pointer to shiny output}

\item{\code{session}}{Pointer to shiny session}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-update_loq_define_lloq"></a>}}
\if{latex}{\out{\hypertarget{method-update_loq_define_lloq}{}}}
\subsection{Method \code{update_loq_define_lloq()}}{
Updates the gui.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{pgu.delegate$update_loq_define_lloq(input, output, session)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{input}}{Pointer to shiny input}

\item{\code{output}}{Pointer to shiny output}

\item{\code{session}}{Pointer to shiny session}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-update_loq_define_uloq"></a>}}
\if{latex}{\out{\hypertarget{method-update_loq_define_uloq}{}}}
\subsection{Method \code{update_loq_define_uloq()}}{
Updates the gui.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{pgu.delegate$update_loq_define_uloq(input, output, session)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{input}}{Pointer to shiny input}

\item{\code{output}}{Pointer to shiny output}

\item{\code{session}}{Pointer to shiny session}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-update_loq_define_table"></a>}}
\if{latex}{\out{\hypertarget{method-update_loq_define_table}{}}}
\subsection{Method \code{update_loq_define_table()}}{
Updates the gui.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{pgu.delegate$update_loq_define_table(input, output, session)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{input}}{Pointer to shiny input}

\item{\code{output}}{Pointer to shiny output}

\item{\code{session}}{Pointer to shiny session}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-update_loq_define_menu"></a>}}
\if{latex}{\out{\hypertarget{method-update_loq_define_menu}{}}}
\subsection{Method \code{update_loq_define_menu()}}{
Updates the gui.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{pgu.delegate$update_loq_define_menu(input, output, session)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{input}}{Pointer to shiny input}

\item{\code{output}}{Pointer to shiny output}

\item{\code{session}}{Pointer to shiny session}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-set_loq_define_values"></a>}}
\if{latex}{\out{\hypertarget{method-set_loq_define_values}{}}}
\subsection{Method \code{set_loq_define_values()}}{
Updates loq class.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{pgu.delegate$set_loq_define_values(input, output, session)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{input}}{Pointer to shiny input}

\item{\code{output}}{Pointer to shiny output}

\item{\code{session}}{Pointer to shiny session}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-set_loq_define_values_globally"></a>}}
\if{latex}{\out{\hypertarget{method-set_loq_define_values_globally}{}}}
\subsection{Method \code{set_loq_define_values_globally()}}{
Updates loq class.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{pgu.delegate$set_loq_define_values_globally(input, output, session)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{input}}{Pointer to shiny input}

\item{\code{output}}{Pointer to shiny output}

\item{\code{session}}{Pointer to shiny session}
}
\if{html}{\out{</div>}}
}
\subsection{Details}{
Imports uploaded data from the R server into the instance variable loqData.
Updates the instance class status.

Example code:
\preformatted{
importLoq = function(input, output, session)\{
  if (private$.status$query(processName = "dataImported"))\{
    tryCatch(\{
      private$.loq$setLoq <- private$.importer$importLoq(self$fileName)
      private$.status$update(processName = "loqImported", value = TRUE)
    \},
    error = function(e) \{
      private$.status$update(processName = "loqImported", value = FALSE)
      shiny::showNotification(paste(e),type = "error", duration = 10)
    \}#error
    )#tryCatch
  \}#if
  else\{
    private$.status$update(processName = "loqImported", value = FALSE)
    shiny::showNotification(paste("No file uploaded to import. Please upload a valid file first."),type = "error", duration = 10)
  \}#else
\}, #function
}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-update_loq_detect_gui"></a>}}
\if{latex}{\out{\hypertarget{method-update_loq_detect_gui}{}}}
\subsection{Method \code{update_loq_detect_gui()}}{
Updates the gui.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{pgu.delegate$update_loq_detect_gui(input, output, session)}\if{html}{\out{</div>}}
}
\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{input}}{Pointer to shiny input}
\item{\code{output}}{Pointer to shiny output}
\item{\code{session}}{Pointer to shiny session}
}
\if{html}{\out{</div>}}
}
}

\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-update_loq_na_handling"></a>}}
\if{latex}{\out{\hypertarget{method-update_loq_na_handling}{}}}
\subsection{Method \code{update_loq_na_handling()}}{
Updates the si.loqHandling shiny widget
corresponding to the respective user defined parameter.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{pgu.delegate$update_loq_na_handling(input, output, session)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{input}}{Pointer to shiny input}

\item{\code{output}}{Pointer to shiny output}

\item{\code{session}}{Pointer to shiny session}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-init_detect_loq"></a>}}
\if{latex}{\out{\hypertarget{method-init_detect_loq}{}}}
\subsection{Method \code{init_detect_loq()}}{
Runs the outlier detection routine of the instance variable outliers.
Updates the instance class status.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{pgu.delegate$init_detect_loq(input, output, session)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{input}}{Pointer to shiny input}

\item{\code{output}}{Pointer to shiny output}

\item{\code{session}}{Pointer to shiny session}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-detect_loq"></a>}}
\if{latex}{\out{\hypertarget{method-detect_loq}{}}}
\subsection{Method \code{detect_loq()}}{
Runs the outlier detection routine of the instance variable outliers.
Updates the instance class status.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{pgu.delegate$detect_loq(input, output, session)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{input}}{Pointer to shiny input}

\item{\code{output}}{Pointer to shiny output}

\item{\code{session}}{Pointer to shiny session}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-update_loq_detect_statistics_tbl"></a>}}
\if{latex}{\out{\hypertarget{method-update_loq_detect_statistics_tbl}{}}}
\subsection{Method \code{update_loq_detect_statistics_tbl()}}{
Updates the numerical loq statistics analysis table
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{pgu.delegate$update_loq_detect_statistics_tbl(input, output, session)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{input}}{Pointer to shiny input}

\item{\code{output}}{Pointer to shiny output}

\item{\code{session}}{Pointer to shiny session}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-update_loq_detect_outlier_tbl"></a>}}
\if{latex}{\out{\hypertarget{method-update_loq_detect_outlier_tbl}{}}}
\subsection{Method \code{update_loq_detect_outlier_tbl()}}{
Updates the numerical loq table.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{pgu.delegate$update_loq_detect_outlier_tbl(input, output, session)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{input}}{Pointer to shiny input}

\item{\code{output}}{Pointer to shiny output}

\item{\code{session}}{Pointer to shiny session}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-update_loq_detect_statistics_graphic"></a>}}
\if{latex}{\out{\hypertarget{method-update_loq_detect_statistics_graphic}{}}}
\subsection{Method \code{update_loq_detect_statistics_graphic()}}{
Updates the loq statistics graphic.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{pgu.delegate$update_loq_detect_statistics_graphic(input, output, session)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{input}}{Pointer to shiny input}

\item{\code{output}}{Pointer to shiny output}

\item{\code{session}}{Pointer to shiny session}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-update_loq_detect_attribute_graphic"></a>}}
\if{latex}{\out{\hypertarget{method-update_loq_detect_attribute_graphic}{}}}
\subsection{Method \code{update_loq_detect_attribute_graphic()}}{
Updates the loq feature compound graphic.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{pgu.delegate$update_loq_detect_attribute_graphic(input, output, session)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{input}}{Pointer to shiny input}

\item{\code{output}}{Pointer to shiny output}

\item{\code{session}}{Pointer to shiny session}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-update_loq_detect_attribute_tbl"></a>}}
\if{latex}{\out{\hypertarget{method-update_loq_detect_attribute_tbl}{}}}
\subsection{Method \code{update_loq_detect_attribute_tbl()}}{
Updates the numerical loq feature table.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{pgu.delegate$update_loq_detect_attribute_tbl(input, output, session)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{input}}{Pointer to shiny input}

\item{\code{output}}{Pointer to shiny output}

\item{\code{session}}{Pointer to shiny session}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-update_loq_mutate_gui"></a>}}
\if{latex}{\out{\hypertarget{method-update_loq_mutate_gui}{}}}
\subsection{Method \code{update_loq_mutate_gui()}}{
Updates the gui.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{pgu.delegate$update_loq_mutate_gui(input, output, session)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{input}}{Pointer to shiny input}

\item{\code{output}}{Pointer to shiny output}

\item{\code{session}}{Pointer to shiny session}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-update_lloq_substitute"></a>}}
\if{latex}{\out{\hypertarget{method-update_lloq_substitute}{}}}
\subsection{Method \code{update_lloq_substitute()}}{
Updates the si.lloqSubstitute shiny widget.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{pgu.delegate$update_lloq_substitute(input, output, session)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{input}}{Pointer to shiny input}

\item{\code{output}}{Pointer to shiny output}

\item{\code{session}}{Pointer to shiny session}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-update_uloq_substitute"></a>}}
\if{latex}{\out{\hypertarget{method-update_uloq_substitute}{}}}
\subsection{Method \code{update_uloq_substitute()}}{
Updates the si.uloqSubstitute shiny widget.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{pgu.delegate$update_uloq_substitute(input, output, session)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{input}}{Pointer to shiny input}

\item{\code{output}}{Pointer to shiny output}

\item{\code{session}}{Pointer to shiny session}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-init_mutate_loq"></a>}}
\if{latex}{\out{\hypertarget{method-init_mutate_loq}{}}}
\subsection{Method \code{init_mutate_loq()}}{
Calls the mutation routine of the instance variable loq on the instance variable filteredData.
The reult is stored in the instance variable loqMutatedData
Updates the instance class status.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{pgu.delegate$init_mutate_loq(input, output, session)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{input}}{Pointer to shiny input}

\item{\code{output}}{Pointer to shiny output}

\item{\code{session}}{Pointer to shiny session}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-mutate_loq"></a>}}
\if{latex}{\out{\hypertarget{method-mutate_loq}{}}}
\subsection{Method \code{mutate_loq()}}{
Calls the mutation routine of the instance variable loq on the instance variable filteredData.
The reult is stored in the instance variable loqMutatedData
Updates the instance class status.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{pgu.delegate$mutate_loq(input, output, session)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{input}}{Pointer to shiny input}

\item{\code{output}}{Pointer to shiny output}

\item{\code{session}}{Pointer to shiny session}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-update_loq_mutate_data_tbl"></a>}}
\if{latex}{\out{\hypertarget{method-update_loq_mutate_data_tbl}{}}}
\subsection{Method \code{update_loq_mutate_data_tbl()}}{
Updates the numerical loq mutate outliers table.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{pgu.delegate$update_loq_mutate_data_tbl(input, output, session)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{input}}{Pointer to shiny input}

\item{\code{output}}{Pointer to shiny output}

\item{\code{session}}{Pointer to shiny session}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-update_loq_mutate_statistics_graphic"></a>}}
\if{latex}{\out{\hypertarget{method-update_loq_mutate_statistics_graphic}{}}}
\subsection{Method \code{update_loq_mutate_statistics_graphic()}}{
Updates the loq mutate statistics graphic.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{pgu.delegate$update_loq_mutate_statistics_graphic(input, output, session)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{input}}{Pointer to shiny input}

\item{\code{output}}{Pointer to shiny output}

\item{\code{session}}{Pointer to shiny session}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-update_loq_mutate_attribute_graphic"></a>}}
\if{latex}{\out{\hypertarget{method-update_loq_mutate_attribute_graphic}{}}}
\subsection{Method \code{update_loq_mutate_attribute_graphic()}}{
Updates the loq mutate feature graphic.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{pgu.delegate$update_loq_mutate_attribute_graphic(input, output, session)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{input}}{Pointer to shiny input}

\item{\code{output}}{Pointer to shiny output}

\item{\code{session}}{Pointer to shiny session}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-init_loq_mutate_attribute_tbl"></a>}}
\if{latex}{\out{\hypertarget{method-init_loq_mutate_attribute_tbl}{}}}
\subsection{Method \code{init_loq_mutate_attribute_tbl()}}{
Updates the numeric loq mutate feature table.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{pgu.delegate$init_loq_mutate_attribute_tbl(input, output, session)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{input}}{Pointer to shiny input}

\item{\code{output}}{Pointer to shiny output}

\item{\code{session}}{Pointer to shiny session}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-update_loq_mutate_attribute_tbl"></a>}}
\if{latex}{\out{\hypertarget{method-update_loq_mutate_attribute_tbl}{}}}
\subsection{Method \code{update_loq_mutate_attribute_tbl()}}{
Updates the numeric loq mutate feature table.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{pgu.delegate$update_loq_mutate_attribute_tbl(input, output, session)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{input}}{Pointer to shiny input}

\item{\code{output}}{Pointer to shiny output}

\item{\code{session}}{Pointer to shiny session}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-optimizeTrafoParameter"></a>}}
\if{latex}{\out{\hypertarget{method-optimizeTrafoParameter}{}}}
\subsection{Method \code{optimizeTrafoParameter()}}{
Calls the optimize routine of the instance variable optimizer on the instance variable loqMutatedData.
Updates the instance class status.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{pgu.delegate$optimizeTrafoParameter(input, output, session)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{input}}{Pointer to shiny input}

\item{\code{output}}{Pointer to shiny output}

\item{\code{session}}{Pointer to shiny session}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-updateDetectedTrafoTypes"></a>}}
\if{latex}{\out{\hypertarget{method-updateDetectedTrafoTypes}{}}}
\subsection{Method \code{updateDetectedTrafoTypes()}}{
Updates the detected trafo types table.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{pgu.delegate$updateDetectedTrafoTypes(input, output, session)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{input}}{Pointer to shiny input}

\item{\code{output}}{Pointer to shiny output}

\item{\code{session}}{Pointer to shiny session}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-updateDetectedTrafoParameter"></a>}}
\if{latex}{\out{\hypertarget{method-updateDetectedTrafoParameter}{}}}
\subsection{Method \code{updateDetectedTrafoParameter()}}{
Updates the detected trafo parameters table.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{pgu.delegate$updateDetectedTrafoParameter(input, output, session)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{input}}{Pointer to shiny input}

\item{\code{output}}{Pointer to shiny output}

\item{\code{session}}{Pointer to shiny session}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-updateTrafoDetectGui"></a>}}
\if{latex}{\out{\hypertarget{method-updateTrafoDetectGui}{}}}
\subsection{Method \code{updateTrafoDetectGui()}}{
Updates the gui.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{pgu.delegate$updateTrafoDetectGui(input, output, session)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{input}}{Pointer to shiny input}

\item{\code{output}}{Pointer to shiny output}

\item{\code{session}}{Pointer to shiny session}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-updateTrafoMutateFeature"></a>}}
\if{latex}{\out{\hypertarget{method-updateTrafoMutateFeature}{}}}
\subsection{Method \code{updateTrafoMutateFeature()}}{
Updates the si.trafoMutateFeature shiny widget.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{pgu.delegate$updateTrafoMutateFeature(input, output, session)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{input}}{Pointer to shiny input}

\item{\code{output}}{Pointer to shiny output}

\item{\code{session}}{Pointer to shiny session}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-updateTrafoMutateType"></a>}}
\if{latex}{\out{\hypertarget{method-updateTrafoMutateType}{}}}
\subsection{Method \code{updateTrafoMutateType()}}{
Updates the si.trafoMutateType shiny widget.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{pgu.delegate$updateTrafoMutateType(input, output, session)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{input}}{Pointer to shiny input}

\item{\code{output}}{Pointer to shiny output}

\item{\code{session}}{Pointer to shiny session}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-updateTrafoMutateLambda"></a>}}
\if{latex}{\out{\hypertarget{method-updateTrafoMutateLambda}{}}}
\subsection{Method \code{updateTrafoMutateLambda()}}{
Updates the ni.trafoMutateLambda shiny widget.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{pgu.delegate$updateTrafoMutateLambda(input, output, session)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{input}}{Pointer to shiny input}

\item{\code{output}}{Pointer to shiny output}

\item{\code{session}}{Pointer to shiny session}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-updateTrafoMutateMirror"></a>}}
\if{latex}{\out{\hypertarget{method-updateTrafoMutateMirror}{}}}
\subsection{Method \code{updateTrafoMutateMirror()}}{
Updates the cb.trafoMutateMirror shiny widget.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{pgu.delegate$updateTrafoMutateMirror(input, output, session)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{input}}{Pointer to shiny input}

\item{\code{output}}{Pointer to shiny output}

\item{\code{session}}{Pointer to shiny session}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-resetTrafoMutateGui"></a>}}
\if{latex}{\out{\hypertarget{method-resetTrafoMutateGui}{}}}
\subsection{Method \code{resetTrafoMutateGui()}}{
Updates the gui.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{pgu.delegate$resetTrafoMutateGui(input, output, session)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{input}}{Pointer to shiny input}

\item{\code{output}}{Pointer to shiny output}

\item{\code{session}}{Pointer to shiny session}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-updateTrafoMutateGui"></a>}}
\if{latex}{\out{\hypertarget{method-updateTrafoMutateGui}{}}}
\subsection{Method \code{updateTrafoMutateGui()}}{
Updates the gui.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{pgu.delegate$updateTrafoMutateGui(input, output, session)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{input}}{Pointer to shiny input}

\item{\code{output}}{Pointer to shiny output}

\item{\code{session}}{Pointer to shiny session}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-trafoMutateFit"></a>}}
\if{latex}{\out{\hypertarget{method-trafoMutateFit}{}}}
\subsection{Method \code{trafoMutateFit()}}{
Estimates the optimal transformation parameters.
Updates the GUI
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{pgu.delegate$trafoMutateFit(input, output, session)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{input}}{Pointer to shiny input}

\item{\code{output}}{Pointer to shiny output}

\item{\code{session}}{Pointer to shiny session}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-trafoMutateGlobal"></a>}}
\if{latex}{\out{\hypertarget{method-trafoMutateGlobal}{}}}
\subsection{Method \code{trafoMutateGlobal()}}{
Calls the transformation routine of the instance variable transformator on the instance variable loqMutatedData.
Updates the instance class status.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{pgu.delegate$trafoMutateGlobal(input, output, session)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{input}}{Pointer to shiny input}

\item{\code{output}}{Pointer to shiny output}

\item{\code{session}}{Pointer to shiny session}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-trafoMutateFeature"></a>}}
\if{latex}{\out{\hypertarget{method-trafoMutateFeature}{}}}
\subsection{Method \code{trafoMutateFeature()}}{
Calls the transformation routine of the instance variable transformator on a user defined attribute
of the instance variable loqMutatedData.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{pgu.delegate$trafoMutateFeature(input, output, session)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{input}}{Pointer to shiny input}

\item{\code{output}}{Pointer to shiny output}

\item{\code{session}}{Pointer to shiny session}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-updateTrafoMutateFeatureGraphic"></a>}}
\if{latex}{\out{\hypertarget{method-updateTrafoMutateFeatureGraphic}{}}}
\subsection{Method \code{updateTrafoMutateFeatureGraphic()}}{
Updates the trafo mutate feature graphic.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{pgu.delegate$updateTrafoMutateFeatureGraphic(input, output, session)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{input}}{Pointer to shiny input}

\item{\code{output}}{Pointer to shiny output}

\item{\code{session}}{Pointer to shiny session}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-updateTrafoMutateFeatureParameterTbl"></a>}}
\if{latex}{\out{\hypertarget{method-updateTrafoMutateFeatureParameterTbl}{}}}
\subsection{Method \code{updateTrafoMutateFeatureParameterTbl()}}{
Updates the trafo mutate feature patameter table.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{pgu.delegate$updateTrafoMutateFeatureParameterTbl(input, output, session)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{input}}{Pointer to shiny input}

\item{\code{output}}{Pointer to shiny output}

\item{\code{session}}{Pointer to shiny session}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-updateTrafoMutateFeatureQualityTbl"></a>}}
\if{latex}{\out{\hypertarget{method-updateTrafoMutateFeatureQualityTbl}{}}}
\subsection{Method \code{updateTrafoMutateFeatureQualityTbl()}}{
Updates the trafo mutate feature quality table.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{pgu.delegate$updateTrafoMutateFeatureQualityTbl(input, output, session)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{input}}{Pointer to shiny input}

\item{\code{output}}{Pointer to shiny output}

\item{\code{session}}{Pointer to shiny session}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-updateTrafoMutateGlobalParameterTbl"></a>}}
\if{latex}{\out{\hypertarget{method-updateTrafoMutateGlobalParameterTbl}{}}}
\subsection{Method \code{updateTrafoMutateGlobalParameterTbl()}}{
Updates the trafo mutate global parameter table.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{pgu.delegate$updateTrafoMutateGlobalParameterTbl(input, output, session)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{input}}{Pointer to shiny input}

\item{\code{output}}{Pointer to shiny output}

\item{\code{session}}{Pointer to shiny session}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-updateTrafoMutateGlobalModelTbl"></a>}}
\if{latex}{\out{\hypertarget{method-updateTrafoMutateGlobalModelTbl}{}}}
\subsection{Method \code{updateTrafoMutateGlobalModelTbl()}}{
Updates the tbl.trafoMutateGlobalModel table.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{pgu.delegate$updateTrafoMutateGlobalModelTbl(input, output, session)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{input}}{Pointer to shiny input}

\item{\code{output}}{Pointer to shiny output}

\item{\code{session}}{Pointer to shiny session}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-updateTrafoMutateGlobalQualityTbl"></a>}}
\if{latex}{\out{\hypertarget{method-updateTrafoMutateGlobalQualityTbl}{}}}
\subsection{Method \code{updateTrafoMutateGlobalQualityTbl()}}{
Updates the tbl.trafoMutateGlobalQuality table.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{pgu.delegate$updateTrafoMutateGlobalQualityTbl(input, output, session)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{input}}{Pointer to shiny input}

\item{\code{output}}{Pointer to shiny output}

\item{\code{session}}{Pointer to shiny session}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-updateTrafoMutateGlobalTestsTbl"></a>}}
\if{latex}{\out{\hypertarget{method-updateTrafoMutateGlobalTestsTbl}{}}}
\subsection{Method \code{updateTrafoMutateGlobalTestsTbl()}}{
Updates the tbl.trafoMutateGlobalTests table.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{pgu.delegate$updateTrafoMutateGlobalTestsTbl(input, output, session)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{input}}{Pointer to shiny input}

\item{\code{output}}{Pointer to shiny output}

\item{\code{session}}{Pointer to shiny session}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-updateTrafoMutateGlobalDataTbl"></a>}}
\if{latex}{\out{\hypertarget{method-updateTrafoMutateGlobalDataTbl}{}}}
\subsection{Method \code{updateTrafoMutateGlobalDataTbl()}}{
Updates the tbl.trafoMutateGlobalData table.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{pgu.delegate$updateTrafoMutateGlobalDataTbl(input, output, session)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{input}}{Pointer to shiny input}

\item{\code{output}}{Pointer to shiny output}

\item{\code{session}}{Pointer to shiny session}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-updateTrafoNormFeature"></a>}}
\if{latex}{\out{\hypertarget{method-updateTrafoNormFeature}{}}}
\subsection{Method \code{updateTrafoNormFeature()}}{
Updates the si.trafoNormFeature shiny widget.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{pgu.delegate$updateTrafoNormFeature(input, output, session)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{input}}{Pointer to shiny input}

\item{\code{output}}{Pointer to shiny output}

\item{\code{session}}{Pointer to shiny session}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-updateTrafoNormMethod"></a>}}
\if{latex}{\out{\hypertarget{method-updateTrafoNormMethod}{}}}
\subsection{Method \code{updateTrafoNormMethod()}}{
Updates the si.trafoNormMethod shiny widget.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{pgu.delegate$updateTrafoNormMethod(input, output, session)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{input}}{Pointer to shiny input}

\item{\code{output}}{Pointer to shiny output}

\item{\code{session}}{Pointer to shiny session}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-updateTrafoNormGui"></a>}}
\if{latex}{\out{\hypertarget{method-updateTrafoNormGui}{}}}
\subsection{Method \code{updateTrafoNormGui()}}{
Updates the gui.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{pgu.delegate$updateTrafoNormGui(input, output, session)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{input}}{Pointer to shiny input}

\item{\code{output}}{Pointer to shiny output}

\item{\code{session}}{Pointer to shiny session}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-trafoNormMutate"></a>}}
\if{latex}{\out{\hypertarget{method-trafoNormMutate}{}}}
\subsection{Method \code{trafoNormMutate()}}{
Calls the scale routine of the instance variable normalizer on the instance variable transformedData.
Updates the instance class status.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{pgu.delegate$trafoNormMutate(input, output, session)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{input}}{Pointer to shiny input}

\item{\code{output}}{Pointer to shiny output}

\item{\code{session}}{Pointer to shiny session}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-updateTrafoNormFeatureGraphic"></a>}}
\if{latex}{\out{\hypertarget{method-updateTrafoNormFeatureGraphic}{}}}
\subsection{Method \code{updateTrafoNormFeatureGraphic()}}{
Updates the impute norm feature compound graphic.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{pgu.delegate$updateTrafoNormFeatureGraphic(input, output, session)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{input}}{Pointer to shiny input}

\item{\code{output}}{Pointer to shiny output}

\item{\code{session}}{Pointer to shiny session}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-resetTrafoNormGui"></a>}}
\if{latex}{\out{\hypertarget{method-resetTrafoNormGui}{}}}
\subsection{Method \code{resetTrafoNormGui()}}{
Updates the gui.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{pgu.delegate$resetTrafoNormGui(input, output, session)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{input}}{Pointer to shiny input}

\item{\code{output}}{Pointer to shiny output}

\item{\code{session}}{Pointer to shiny session}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-updateTrafoNormFeatureStatisticsTbl"></a>}}
\if{latex}{\out{\hypertarget{method-updateTrafoNormFeatureStatisticsTbl}{}}}
\subsection{Method \code{updateTrafoNormFeatureStatisticsTbl()}}{
Updates the numerical impute norm analysis table for a user defined feature.
corresponding to the respective user defined attributes.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{pgu.delegate$updateTrafoNormFeatureStatisticsTbl(input, output, session)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{input}}{Pointer to shiny input}

\item{\code{output}}{Pointer to shiny output}

\item{\code{session}}{Pointer to shiny session}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-updateTrafoNormStatisticsTbl"></a>}}
\if{latex}{\out{\hypertarget{method-updateTrafoNormStatisticsTbl}{}}}
\subsection{Method \code{updateTrafoNormStatisticsTbl()}}{
Updates the numerical impute norm analysis table.
corresponding to the respective user defined attributes.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{pgu.delegate$updateTrafoNormStatisticsTbl(input, output, session)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{input}}{Pointer to shiny input}

\item{\code{output}}{Pointer to shiny output}

\item{\code{session}}{Pointer to shiny session}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-updateTrafoNormParameterTbl"></a>}}
\if{latex}{\out{\hypertarget{method-updateTrafoNormParameterTbl}{}}}
\subsection{Method \code{updateTrafoNormParameterTbl()}}{
Updates the impute norm parameter table.
corresponding to the respective user defined attributes.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{pgu.delegate$updateTrafoNormParameterTbl(input, output, session)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{input}}{Pointer to shiny input}

\item{\code{output}}{Pointer to shiny output}

\item{\code{session}}{Pointer to shiny session}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-updateTrafoNormDataTbl"></a>}}
\if{latex}{\out{\hypertarget{method-updateTrafoNormDataTbl}{}}}
\subsection{Method \code{updateTrafoNormDataTbl()}}{
Updates the impute norm scaled data table.
corresponding to the respective user defined attributes.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{pgu.delegate$updateTrafoNormDataTbl(input, output, session)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{input}}{Pointer to shiny input}

\item{\code{output}}{Pointer to shiny output}

\item{\code{session}}{Pointer to shiny session}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-imputeMissingsAnalyze"></a>}}
\if{latex}{\out{\hypertarget{method-imputeMissingsAnalyze}{}}}
\subsection{Method \code{imputeMissingsAnalyze()}}{
Calls the missing detection routine of the instance variable imputer
on the instance variable normalizedData.
Updates the instance class status.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{pgu.delegate$imputeMissingsAnalyze(input, output, session)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{input}}{Pointer to shiny input}

\item{\code{output}}{Pointer to shiny output}

\item{\code{session}}{Pointer to shiny session}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-updateImputeMissingsGraphic"></a>}}
\if{latex}{\out{\hypertarget{method-updateImputeMissingsGraphic}{}}}
\subsection{Method \code{updateImputeMissingsGraphic()}}{
Updates the plt.imputeMissingsSummary graphic.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{pgu.delegate$updateImputeMissingsGraphic(input, output, session)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{input}}{Pointer to shiny input}

\item{\code{output}}{Pointer to shiny output}

\item{\code{session}}{Pointer to shiny session}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-updateImputeMissingsStatisticsTbl"></a>}}
\if{latex}{\out{\hypertarget{method-updateImputeMissingsStatisticsTbl}{}}}
\subsection{Method \code{updateImputeMissingsStatisticsTbl()}}{
Updates the tbl.imputeMissingsStatistics table.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{pgu.delegate$updateImputeMissingsStatisticsTbl(input, output, session)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{input}}{Pointer to shiny input}

\item{\code{output}}{Pointer to shiny output}

\item{\code{session}}{Pointer to shiny session}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-updateImputeMissingsDistributionTbl"></a>}}
\if{latex}{\out{\hypertarget{method-updateImputeMissingsDistributionTbl}{}}}
\subsection{Method \code{updateImputeMissingsDistributionTbl()}}{
Updates the tbl.imputeMissingsDistribution table.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{pgu.delegate$updateImputeMissingsDistributionTbl(input, output, session)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{input}}{Pointer to shiny input}

\item{\code{output}}{Pointer to shiny output}

\item{\code{session}}{Pointer to shiny session}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-updateImputeMissingCharacteristicsGraphic"></a>}}
\if{latex}{\out{\hypertarget{method-updateImputeMissingCharacteristicsGraphic}{}}}
\subsection{Method \code{updateImputeMissingCharacteristicsGraphic()}}{
Updates the plt.imputeMissingsPairs graphic.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{pgu.delegate$updateImputeMissingCharacteristicsGraphic(input, output, session)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{input}}{Pointer to shiny input}

\item{\code{output}}{Pointer to shiny output}

\item{\code{session}}{Pointer to shiny session}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-updateImputeMissingsCharacteristicsTbl"></a>}}
\if{latex}{\out{\hypertarget{method-updateImputeMissingsCharacteristicsTbl}{}}}
\subsection{Method \code{updateImputeMissingsCharacteristicsTbl()}}{
Updates the tbl.imputeMissingsCharacteristics table.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{pgu.delegate$updateImputeMissingsCharacteristicsTbl(input, output, session)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{input}}{Pointer to shiny input}

\item{\code{output}}{Pointer to shiny output}

\item{\code{session}}{Pointer to shiny session}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-updateImputeMissingsDetailTbl"></a>}}
\if{latex}{\out{\hypertarget{method-updateImputeMissingsDetailTbl}{}}}
\subsection{Method \code{updateImputeMissingsDetailTbl()}}{
Updates the tbl.imputeDetectDetail table.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{pgu.delegate$updateImputeMissingsDetailTbl(input, output, session)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{input}}{Pointer to shiny input}

\item{\code{output}}{Pointer to shiny output}

\item{\code{session}}{Pointer to shiny session\preformatted{
                        updateImputeMissingsDataTbl = function(input, output, session)\{
                          if(self$status$query(processName = "naDetected"))\{
                            output$tbl.imputeMissingsData <- DT::renderDataTable(
                              self$filteredMetadata$rawData \%>\%
                                dplyr::right_join(self$normalizedData$rawData, by = "Sample Name") \%>\%
                                format.data.frame(scientific = TRUE, digits = 4) \%>\%
                                DT::datatable(
                                  extensions = "Buttons",
                                  options = list(
                                    scrollX = TRUE,
                                    scrollY = '350px',
                                    paging = FALSE,
                                    dom = "Blfrtip",
                                    buttons = list(list(
                                      extend = 'csv',
                                      filename = self$fileName$predict("imputationSiteDetectionData") \%>\%
                                        tools::file_path_sans_ext(),
                                      text = "Download"
                                    ))#buttons
                                  )#options
                                )#DT::datatable
                            )#output
                          \}#if
                          else\{
                            output$tbl.imputeMissingsData <- DT::renderDataTable(NULL)
                          \}#else
                        \}, #function
}}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-updateImputeOutliersMethod"></a>}}
\if{latex}{\out{\hypertarget{method-updateImputeOutliersMethod}{}}}
\subsection{Method \code{updateImputeOutliersMethod()}}{
Updates the si.imputeOutliersMethod shiny widget.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{pgu.delegate$updateImputeOutliersMethod(input, output, session)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{input}}{Pointer to shiny input}

\item{\code{output}}{Pointer to shiny output}

\item{\code{session}}{Pointer to shiny session}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-updateImputeOutliersFeature"></a>}}
\if{latex}{\out{\hypertarget{method-updateImputeOutliersFeature}{}}}
\subsection{Method \code{updateImputeOutliersFeature()}}{
Updates the si.imputeOutliersFeature shiny widget.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{pgu.delegate$updateImputeOutliersFeature(input, output, session)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{input}}{Pointer to shiny input}

\item{\code{output}}{Pointer to shiny output}

\item{\code{session}}{Pointer to shiny session}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-updateImputeOutliersAlpha"></a>}}
\if{latex}{\out{\hypertarget{method-updateImputeOutliersAlpha}{}}}
\subsection{Method \code{updateImputeOutliersAlpha()}}{
Updates the ni.imputeOutliersAlpha shiny widget.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{pgu.delegate$updateImputeOutliersAlpha(input, output, session)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{input}}{Pointer to shiny input}

\item{\code{output}}{Pointer to shiny output}

\item{\code{session}}{Pointer to shiny session}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-updateImputeOutliersEpsilon"></a>}}
\if{latex}{\out{\hypertarget{method-updateImputeOutliersEpsilon}{}}}
\subsection{Method \code{updateImputeOutliersEpsilon()}}{
Updates the ni.imputeOutliersEpsilon shiny widget.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{pgu.delegate$updateImputeOutliersEpsilon(input, output, session)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{input}}{Pointer to shiny input}

\item{\code{output}}{Pointer to shiny output}

\item{\code{session}}{Pointer to shiny session}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-updateImputeOutliersMinSamples"></a>}}
\if{latex}{\out{\hypertarget{method-updateImputeOutliersMinSamples}{}}}
\subsection{Method \code{updateImputeOutliersMinSamples()}}{
Updates the ni.imputeOutliersMinSamples shiny widget.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{pgu.delegate$updateImputeOutliersMinSamples(input, output, session)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{input}}{Pointer to shiny input}

\item{\code{output}}{Pointer to shiny output}

\item{\code{session}}{Pointer to shiny session}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-updateImputeOutliersGamma"></a>}}
\if{latex}{\out{\hypertarget{method-updateImputeOutliersGamma}{}}}
\subsection{Method \code{updateImputeOutliersGamma()}}{
Updates the ni.imputeOutliersGamma shiny widget.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{pgu.delegate$updateImputeOutliersGamma(input, output, session)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{input}}{Pointer to shiny input}

\item{\code{output}}{Pointer to shiny output}

\item{\code{session}}{Pointer to shiny session}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-updateImputeOutliersNu"></a>}}
\if{latex}{\out{\hypertarget{method-updateImputeOutliersNu}{}}}
\subsection{Method \code{updateImputeOutliersNu()}}{
Updates the ni.imputeOutliersNu shiny widget.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{pgu.delegate$updateImputeOutliersNu(input, output, session)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{input}}{Pointer to shiny input}

\item{\code{output}}{Pointer to shiny output}

\item{\code{session}}{Pointer to shiny session}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-updateImputeOutliersCutoff"></a>}}
\if{latex}{\out{\hypertarget{method-updateImputeOutliersCutoff}{}}}
\subsection{Method \code{updateImputeOutliersCutoff()}}{
Updates the ni.imputeOutliersCutoff shiny widget.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{pgu.delegate$updateImputeOutliersCutoff(input, output, session)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{input}}{Pointer to shiny input}

\item{\code{output}}{Pointer to shiny output}

\item{\code{session}}{Pointer to shiny session}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-updateImputeOutliersK"></a>}}
\if{latex}{\out{\hypertarget{method-updateImputeOutliersK}{}}}
\subsection{Method \code{updateImputeOutliersK()}}{
Updates the ni.imputeOutliersK shiny widget.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{pgu.delegate$updateImputeOutliersK(input, output, session)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{input}}{Pointer to shiny input}

\item{\code{output}}{Pointer to shiny output}

\item{\code{session}}{Pointer to shiny session}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-updateImputeOutliersSeed"></a>}}
\if{latex}{\out{\hypertarget{method-updateImputeOutliersSeed}{}}}
\subsection{Method \code{updateImputeOutliersSeed()}}{
Updates the ni.imputeOutliersSeed shiny widget.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{pgu.delegate$updateImputeOutliersSeed(input, output, session)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{input}}{Pointer to shiny input}

\item{\code{output}}{Pointer to shiny output}

\item{\code{session}}{Pointer to shiny session}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-updateImputeOutliersGui"></a>}}
\if{latex}{\out{\hypertarget{method-updateImputeOutliersGui}{}}}
\subsection{Method \code{updateImputeOutliersGui()}}{
Updates the gui.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{pgu.delegate$updateImputeOutliersGui(input, output, session)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{input}}{Pointer to shiny input}

\item{\code{output}}{Pointer to shiny output}

\item{\code{session}}{Pointer to shiny session}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-resetImputeOutliersGui"></a>}}
\if{latex}{\out{\hypertarget{method-resetImputeOutliersGui}{}}}
\subsection{Method \code{resetImputeOutliersGui()}}{
Updates the gui.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{pgu.delegate$resetImputeOutliersGui(input, output, session)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{input}}{Pointer to shiny input}

\item{\code{output}}{Pointer to shiny output}

\item{\code{session}}{Pointer to shiny session}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-imputeOutliersDetect"></a>}}
\if{latex}{\out{\hypertarget{method-imputeOutliersDetect}{}}}
\subsection{Method \code{imputeOutliersDetect()}}{
Calls the detectOutliers routine of the instance variable outliers
on the instance variable normalizedData.
Updates the instance class status.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{pgu.delegate$imputeOutliersDetect(input, output, session)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{input}}{Pointer to shiny input}

\item{\code{output}}{Pointer to shiny output}

\item{\code{session}}{Pointer to shiny session}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-updateImputeOutliersGraphic"></a>}}
\if{latex}{\out{\hypertarget{method-updateImputeOutliersGraphic}{}}}
\subsection{Method \code{updateImputeOutliersGraphic()}}{
Updates the plt.outliersImputeSummary graphic.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{pgu.delegate$updateImputeOutliersGraphic(input, output, session)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{input}}{Pointer to shiny input}

\item{\code{output}}{Pointer to shiny output}

\item{\code{session}}{Pointer to shiny session}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-updateImputeOutliersFeatureGraphic"></a>}}
\if{latex}{\out{\hypertarget{method-updateImputeOutliersFeatureGraphic}{}}}
\subsection{Method \code{updateImputeOutliersFeatureGraphic()}}{
Updates the plt.outliersImputeFeature graphic.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{pgu.delegate$updateImputeOutliersFeatureGraphic(input, output, session)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{input}}{Pointer to shiny input}

\item{\code{output}}{Pointer to shiny output}

\item{\code{session}}{Pointer to shiny session}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-updateImputeOutliersFeatureTbl"></a>}}
\if{latex}{\out{\hypertarget{method-updateImputeOutliersFeatureTbl}{}}}
\subsection{Method \code{updateImputeOutliersFeatureTbl()}}{
Updates the numeric outlier feature table.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{pgu.delegate$updateImputeOutliersFeatureTbl(input, output, session)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{input}}{Pointer to shiny input}

\item{\code{output}}{Pointer to shiny output}

\item{\code{session}}{Pointer to shiny session}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-updateImputeOutliersStatisticsTbl"></a>}}
\if{latex}{\out{\hypertarget{method-updateImputeOutliersStatisticsTbl}{}}}
\subsection{Method \code{updateImputeOutliersStatisticsTbl()}}{
Updates the numerical loq statistics analysis table
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{pgu.delegate$updateImputeOutliersStatisticsTbl(input, output, session)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{input}}{Pointer to shiny input}

\item{\code{output}}{Pointer to shiny output}

\item{\code{session}}{Pointer to shiny session}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-updateImputeOutliersDetailTbl"></a>}}
\if{latex}{\out{\hypertarget{method-updateImputeOutliersDetailTbl}{}}}
\subsection{Method \code{updateImputeOutliersDetailTbl()}}{
Updates the numerical outlier table.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{pgu.delegate$updateImputeOutliersDetailTbl(input, output, session)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{input}}{Pointer to shiny input}

\item{\code{output}}{Pointer to shiny output}

\item{\code{session}}{Pointer to shiny session}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-updateImputeMutateFeature"></a>}}
\if{latex}{\out{\hypertarget{method-updateImputeMutateFeature}{}}}
\subsection{Method \code{updateImputeMutateFeature()}}{
Updates the si.imputeMutateFeature shiny widget.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{pgu.delegate$updateImputeMutateFeature(input, output, session)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{input}}{Pointer to shiny input}

\item{\code{output}}{Pointer to shiny output}

\item{\code{session}}{Pointer to shiny session}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-updateImputeMutateMethod"></a>}}
\if{latex}{\out{\hypertarget{method-updateImputeMutateMethod}{}}}
\subsection{Method \code{updateImputeMutateMethod()}}{
Updates the si.imputeMutateMethod shiny widget.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{pgu.delegate$updateImputeMutateMethod(input, output, session)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{input}}{Pointer to shiny input}

\item{\code{output}}{Pointer to shiny output}

\item{\code{session}}{Pointer to shiny session}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-updateImputeMutateNNeighbors"></a>}}
\if{latex}{\out{\hypertarget{method-updateImputeMutateNNeighbors}{}}}
\subsection{Method \code{updateImputeMutateNNeighbors()}}{
Updates the ni.imputeMutateNumberOfNeighbors shiny widget.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{pgu.delegate$updateImputeMutateNNeighbors(input, output, session)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{input}}{Pointer to shiny input}

\item{\code{output}}{Pointer to shiny output}

\item{\code{session}}{Pointer to shiny session}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-updateImputeMutatePredFrac"></a>}}
\if{latex}{\out{\hypertarget{method-updateImputeMutatePredFrac}{}}}
\subsection{Method \code{updateImputeMutatePredFrac()}}{
Updates the ni.imputeMutatePredFrac shiny widget.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{pgu.delegate$updateImputeMutatePredFrac(input, output, session)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{input}}{Pointer to shiny input}

\item{\code{output}}{Pointer to shiny output}

\item{\code{session}}{Pointer to shiny session}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-updateImputeMutateOutfluxThr"></a>}}
\if{latex}{\out{\hypertarget{method-updateImputeMutateOutfluxThr}{}}}
\subsection{Method \code{updateImputeMutateOutfluxThr()}}{
Updates the ni.imputeMutateOutfluxThr shiny widget.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{pgu.delegate$updateImputeMutateOutfluxThr(input, output, session)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{input}}{Pointer to shiny input}

\item{\code{output}}{Pointer to shiny output}

\item{\code{session}}{Pointer to shiny session}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-updateImputeMutateSeed"></a>}}
\if{latex}{\out{\hypertarget{method-updateImputeMutateSeed}{}}}
\subsection{Method \code{updateImputeMutateSeed()}}{
Updates the ni.imputeMutateSeed shiny widget.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{pgu.delegate$updateImputeMutateSeed(input, output, session)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{input}}{Pointer to shiny input}

\item{\code{output}}{Pointer to shiny output}

\item{\code{session}}{Pointer to shiny session}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-updateImputeMutateIterations"></a>}}
\if{latex}{\out{\hypertarget{method-updateImputeMutateIterations}{}}}
\subsection{Method \code{updateImputeMutateIterations()}}{
Updates the ni.imputeMutateIterations shiny widget.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{pgu.delegate$updateImputeMutateIterations(input, output, session)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{input}}{Pointer to shiny input}

\item{\code{output}}{Pointer to shiny output}

\item{\code{session}}{Pointer to shiny session}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-updateImputeMutateGui"></a>}}
\if{latex}{\out{\hypertarget{method-updateImputeMutateGui}{}}}
\subsection{Method \code{updateImputeMutateGui()}}{
Updates the gui.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{pgu.delegate$updateImputeMutateGui(input, output, session)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{input}}{Pointer to shiny input}

\item{\code{output}}{Pointer to shiny output}

\item{\code{session}}{Pointer to shiny session}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-resetImputeMutateGui"></a>}}
\if{latex}{\out{\hypertarget{method-resetImputeMutateGui}{}}}
\subsection{Method \code{resetImputeMutateGui()}}{
Resets the gui.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{pgu.delegate$resetImputeMutateGui(input, output, session)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{input}}{Pointer to shiny input}

\item{\code{output}}{Pointer to shiny output}

\item{\code{session}}{Pointer to shiny session}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-imputeMutateMutate"></a>}}
\if{latex}{\out{\hypertarget{method-imputeMutateMutate}{}}}
\subsection{Method \code{imputeMutateMutate()}}{
Calls the mutate imputation site routine of the instance variable imputer on the instance variable transformedData.
Updates the instance class status.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{pgu.delegate$imputeMutateMutate(input, output, session)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{input}}{Pointer to shiny input}

\item{\code{output}}{Pointer to shiny output}

\item{\code{session}}{Pointer to shiny session}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-updateImputeFluxGraphic"></a>}}
\if{latex}{\out{\hypertarget{method-updateImputeFluxGraphic}{}}}
\subsection{Method \code{updateImputeFluxGraphic()}}{
Updates the plt.imputeMutateFlux graphic.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{pgu.delegate$updateImputeFluxGraphic(input, output, session)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{input}}{Pointer to shiny input}

\item{\code{output}}{Pointer to shiny output}

\item{\code{session}}{Pointer to shiny session}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-updateImputeMutateGraphic"></a>}}
\if{latex}{\out{\hypertarget{method-updateImputeMutateGraphic}{}}}
\subsection{Method \code{updateImputeMutateGraphic()}}{
Updates the plt.imputeMutateSummary graphic.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{pgu.delegate$updateImputeMutateGraphic(input, output, session)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{input}}{Pointer to shiny input}

\item{\code{output}}{Pointer to shiny output}

\item{\code{session}}{Pointer to shiny session}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-updateImputeMutateStatisticsTbl"></a>}}
\if{latex}{\out{\hypertarget{method-updateImputeMutateStatisticsTbl}{}}}
\subsection{Method \code{updateImputeMutateStatisticsTbl()}}{
Updates the tbl.imputeMutateStatistics table.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{pgu.delegate$updateImputeMutateStatisticsTbl(input, output, session)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{input}}{Pointer to shiny input}

\item{\code{output}}{Pointer to shiny output}

\item{\code{session}}{Pointer to shiny session}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-updateImputeMutateDistributionTbl"></a>}}
\if{latex}{\out{\hypertarget{method-updateImputeMutateDistributionTbl}{}}}
\subsection{Method \code{updateImputeMutateDistributionTbl()}}{
Updates the tbl.imputeMutateDistribution table.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{pgu.delegate$updateImputeMutateDistributionTbl(input, output, session)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{input}}{Pointer to shiny input}

\item{\code{output}}{Pointer to shiny output}

\item{\code{session}}{Pointer to shiny session}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-updateImputeMutateFeatureDetailGraphic"></a>}}
\if{latex}{\out{\hypertarget{method-updateImputeMutateFeatureDetailGraphic}{}}}
\subsection{Method \code{updateImputeMutateFeatureDetailGraphic()}}{
Updates the plt.imputeMutateFeatureDetail graphic.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{pgu.delegate$updateImputeMutateFeatureDetailGraphic(input, output, session)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{input}}{Pointer to shiny input}

\item{\code{output}}{Pointer to shiny output}

\item{\code{session}}{Pointer to shiny session}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-updateImputeMutateFeatureDetailTbl"></a>}}
\if{latex}{\out{\hypertarget{method-updateImputeMutateFeatureDetailTbl}{}}}
\subsection{Method \code{updateImputeMutateFeatureDetailTbl()}}{
Updates the tbl.imputeMutateFeatureDetail table.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{pgu.delegate$updateImputeMutateFeatureDetailTbl(input, output, session)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{input}}{Pointer to shiny input}

\item{\code{output}}{Pointer to shiny output}

\item{\code{session}}{Pointer to shiny session}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-updateImputeMutateDetailTbl"></a>}}
\if{latex}{\out{\hypertarget{method-updateImputeMutateDetailTbl}{}}}
\subsection{Method \code{updateImputeMutateDetailTbl()}}{
Updates the tbl.imputeMutateDetail table.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{pgu.delegate$updateImputeMutateDetailTbl(input, output, session)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{input}}{Pointer to shiny input}

\item{\code{output}}{Pointer to shiny output}

\item{\code{session}}{Pointer to shiny session}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-updateImputeMutateDataTbl"></a>}}
\if{latex}{\out{\hypertarget{method-updateImputeMutateDataTbl}{}}}
\subsection{Method \code{updateImputeMutateDataTbl()}}{
Updates the tbl.imputeMutateData table.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{pgu.delegate$updateImputeMutateDataTbl(input, output, session)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{input}}{Pointer to shiny input}

\item{\code{output}}{Pointer to shiny output}

\item{\code{session}}{Pointer to shiny session}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-validate"></a>}}
\if{latex}{\out{\hypertarget{method-validate}{}}}
\subsection{Method \code{validate()}}{
Calls the validate routine of the instance variable validator on the instance variables rawData and clenaedData.
Updates the instance class status.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{pgu.delegate$validate(input, output, session)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{input}}{Pointer to shiny input}

\item{\code{output}}{Pointer to shiny output}

\item{\code{session}}{Pointer to shiny session}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-updateAnalysisValidationGui"></a>}}
\if{latex}{\out{\hypertarget{method-updateAnalysisValidationGui}{}}}
\subsection{Method \code{updateAnalysisValidationGui()}}{
Updates the si.analysisValidationFeature shiny widget.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{pgu.delegate$updateAnalysisValidationGui(input, output, session)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{input}}{Pointer to shiny input}

\item{\code{output}}{Pointer to shiny output}

\item{\code{session}}{Pointer to shiny session}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-updateAnalysisValidationGraphic"></a>}}
\if{latex}{\out{\hypertarget{method-updateAnalysisValidationGraphic}{}}}
\subsection{Method \code{updateAnalysisValidationGraphic()}}{
Updates the plt.analysisValidationFeature shiny widget.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{pgu.delegate$updateAnalysisValidationGraphic(input, output, session)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{input}}{Pointer to shiny input}

\item{\code{output}}{Pointer to shiny output}

\item{\code{session}}{Pointer to shiny session}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-updateAnalysisValidationTestTbl"></a>}}
\if{latex}{\out{\hypertarget{method-updateAnalysisValidationTestTbl}{}}}
\subsection{Method \code{updateAnalysisValidationTestTbl()}}{
Updtates the tbl.analysisValidationTest table.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{pgu.delegate$updateAnalysisValidationTestTbl(input, output, session)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{input}}{Pointer to shiny input}

\item{\code{output}}{Pointer to shiny output}

\item{\code{session}}{Pointer to shiny session}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-updateCentralMomentsOrgTbl"></a>}}
\if{latex}{\out{\hypertarget{method-updateCentralMomentsOrgTbl}{}}}
\subsection{Method \code{updateCentralMomentsOrgTbl()}}{
Updtates the tbl.centralMomentsOrg table.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{pgu.delegate$updateCentralMomentsOrgTbl(input, output, session)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{input}}{Pointer to shiny input}

\item{\code{output}}{Pointer to shiny output}

\item{\code{session}}{Pointer to shiny session}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-updateCentralMomentsImpTbl"></a>}}
\if{latex}{\out{\hypertarget{method-updateCentralMomentsImpTbl}{}}}
\subsection{Method \code{updateCentralMomentsImpTbl()}}{
Updtates the tbl.centralMomentsImp table.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{pgu.delegate$updateCentralMomentsImpTbl(input, output, session)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{input}}{Pointer to shiny input}

\item{\code{output}}{Pointer to shiny output}

\item{\code{session}}{Pointer to shiny session}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-updateCentralMomentsDeltaTbl"></a>}}
\if{latex}{\out{\hypertarget{method-updateCentralMomentsDeltaTbl}{}}}
\subsection{Method \code{updateCentralMomentsDeltaTbl()}}{
Updtates the tbl.centralMomentsDelta table.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{pgu.delegate$updateCentralMomentsDeltaTbl(input, output, session)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{input}}{Pointer to shiny input}

\item{\code{output}}{Pointer to shiny output}

\item{\code{session}}{Pointer to shiny session}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-updateCorrelationValidationScatterGraphic"></a>}}
\if{latex}{\out{\hypertarget{method-updateCorrelationValidationScatterGraphic}{}}}
\subsection{Method \code{updateCorrelationValidationScatterGraphic()}}{
Updtates the plt.correlationValidationScatter graphic.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{pgu.delegate$updateCorrelationValidationScatterGraphic(input, output, session)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{input}}{Pointer to shiny input}

\item{\code{output}}{Pointer to shiny output}

\item{\code{session}}{Pointer to shiny session}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-updateCorrelationValidationBoxPlotGraphic"></a>}}
\if{latex}{\out{\hypertarget{method-updateCorrelationValidationBoxPlotGraphic}{}}}
\subsection{Method \code{updateCorrelationValidationBoxPlotGraphic()}}{
Updtates the plt.correlationValidationBoxPlot graphic.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{pgu.delegate$updateCorrelationValidationBoxPlotGraphic(input, output, session)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{input}}{Pointer to shiny input}

\item{\code{output}}{Pointer to shiny output}

\item{\code{session}}{Pointer to shiny session}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-updateCorrelationValidationDeviationTbl"></a>}}
\if{latex}{\out{\hypertarget{method-updateCorrelationValidationDeviationTbl}{}}}
\subsection{Method \code{updateCorrelationValidationDeviationTbl()}}{
Updtates the tbl.correlationValidationDeviation table.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{pgu.delegate$updateCorrelationValidationDeviationTbl(input, output, session)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{input}}{Pointer to shiny input}

\item{\code{output}}{Pointer to shiny output}

\item{\code{session}}{Pointer to shiny session}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-updateCorrelationValidationDataTbl"></a>}}
\if{latex}{\out{\hypertarget{method-updateCorrelationValidationDataTbl}{}}}
\subsection{Method \code{updateCorrelationValidationDataTbl()}}{
Updtates the tbl.correlationValidationData table.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{pgu.delegate$updateCorrelationValidationDataTbl(input, output, session)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{input}}{Pointer to shiny input}

\item{\code{output}}{Pointer to shiny output}

\item{\code{session}}{Pointer to shiny session}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-exportFileName"></a>}}
\if{latex}{\out{\hypertarget{method-exportFileName}{}}}
\subsection{Method \code{exportFileName()}}{
Creates and returns an export filename.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{pgu.delegate$exportFileName(input, output, session)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{input}}{Pointer to shiny input}

\item{\code{output}}{Pointer to shiny output}

\item{\code{session}}{Pointer to shiny session}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
export filename
(character)
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-exportData"></a>}}
\if{latex}{\out{\hypertarget{method-exportData}{}}}
\subsection{Method \code{exportData()}}{
Exports the pguIMP analysis results
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{pgu.delegate$exportData(input, file)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{input}}{Pointer to shiny input}

\item{\code{file}}{export filename
(character)}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-reportFileName"></a>}}
\if{latex}{\out{\hypertarget{method-reportFileName}{}}}
\subsection{Method \code{reportFileName()}}{
Creates and returns a report filename.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{pgu.delegate$reportFileName(input, output, session)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{input}}{Pointer to shiny input}

\item{\code{output}}{Pointer to shiny output}

\item{\code{session}}{Pointer to shiny session}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
export filename
(character)
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-writeReport"></a>}}
\if{latex}{\out{\hypertarget{method-writeReport}{}}}
\subsection{Method \code{writeReport()}}{
Exports a report on the pguIMP analysis
in pdf format.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{pgu.delegate$writeReport(input, file)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{input}}{Pointer to shiny input}

\item{\code{file}}{export filename
(character)}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-hide_outdated_results"></a>}}
\if{latex}{\out{\hypertarget{method-hide_outdated_results}{}}}
\subsection{Method \code{hide_outdated_results()}}{
Updates the gui if analysis parameters change.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{pgu.delegate$hide_outdated_results(input, output, session)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{input}}{Pointer to shiny input}

\item{\code{output}}{Pointer to shiny output}

\item{\code{session}}{Pointer to shiny session}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-update_help_html"></a>}}
\if{latex}{\out{\hypertarget{method-update_help_html}{}}}
\subsection{Method \code{update_help_html()}}{
Updates the gui if analysis parameters change.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{pgu.delegate$update_help_html(input, output, session)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{input}}{Pointer to shiny input}

\item{\code{output}}{Pointer to shiny output}

\item{\code{session}}{Pointer to shiny session}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-clone"></a>}}
\if{latex}{\out{\hypertarget{method-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{pgu.delegate$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
