% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pguCorrelator.R
\name{pgu.correlator}
\alias{pgu.correlator}
\title{pgu.correlator}
\format{
[R6::R6Class] object.
}
\description{
An R6 class that performs pairwise correlation on the pguIMP data set.
}
\section{Construction}{

x <- pguIMP::pgu.correlator$new()
}

\examples{
require(dplyr)
require(tibble)
data(iris)
data_df <- iris \%>\%
  tibble::as_tibble() \%>\%
  dplyr::select(-c("Species"))
correlator = pguIMP::pgu.correlator$new(data_df)
}
\author{
Sebastian Malkusch
}
\section{Active bindings}{
\if{html}{\out{<div class="r6-active-bindings">}}
\describe{
\item{\code{featureNames}}{Returns the instance variable featureNames.
(character)}

\item{\code{setFeatureNames}}{Sets the instance variable featureNames.
It further initializes the instance variables:
intercept, pIntercept, slope, pSlope.
(character)}

\item{\code{method}}{Returns the instance variable method.
(character)}

\item{\code{r}}{Returns the instance variable r.
(matrix)}

\item{\code{pPearson}}{Returns the instance variable pPearson.
(matrix)}

\item{\code{tau}}{Returns the instance variable tau.
(matrix)}

\item{\code{pKendall}}{Returns the instance variable pKendall.
(matrix)}

\item{\code{rho}}{Returns the instance variable rho.
(matrix)}

\item{\code{pSpearman}}{Returns the instance variable pSpearman.
(matrix)}

\item{\code{abscissa}}{Returns the instance variable abscissa.
(character)}

\item{\code{setAbscissa}}{Sets the instance variable abscicca to value.}

\item{\code{ordinate}}{Returns the instance variable ordinate.
(character)}

\item{\code{setOrdinate}}{Sets the instance variable ordinate to value.}

\item{\code{test}}{Returns the instance variable test.
(stats::cor.test)}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-pgu.correlator-new}{\code{pgu.correlator$new()}}
\item \href{#method-pgu.correlator-finalize}{\code{pgu.correlator$finalize()}}
\item \href{#method-pgu.correlator-print}{\code{pgu.correlator$print()}}
\item \href{#method-pgu.correlator-resetCorrelator}{\code{pgu.correlator$resetCorrelator()}}
\item \href{#method-pgu.correlator-resetMatrix}{\code{pgu.correlator$resetMatrix()}}
\item \href{#method-pgu.correlator-featureIdx}{\code{pgu.correlator$featureIdx()}}
\item \href{#method-pgu.correlator-calcCorrelationNumeric}{\code{pgu.correlator$calcCorrelationNumeric()}}
\item \href{#method-pgu.correlator-createCorrelationMatrixPearson}{\code{pgu.correlator$createCorrelationMatrixPearson()}}
\item \href{#method-pgu.correlator-createCorrelationMatrixKendall}{\code{pgu.correlator$createCorrelationMatrixKendall()}}
\item \href{#method-pgu.correlator-createCorrelationMatrixSpearman}{\code{pgu.correlator$createCorrelationMatrixSpearman()}}
\item \href{#method-pgu.correlator-correlate}{\code{pgu.correlator$correlate()}}
\item \href{#method-pgu.correlator-printFeature}{\code{pgu.correlator$printFeature()}}
\item \href{#method-pgu.correlator-printRTbl}{\code{pgu.correlator$printRTbl()}}
\item \href{#method-pgu.correlator-printPPearsonTbl}{\code{pgu.correlator$printPPearsonTbl()}}
\item \href{#method-pgu.correlator-printTauTbl}{\code{pgu.correlator$printTauTbl()}}
\item \href{#method-pgu.correlator-printPKendallTbl}{\code{pgu.correlator$printPKendallTbl()}}
\item \href{#method-pgu.correlator-printRhoTbl}{\code{pgu.correlator$printRhoTbl()}}
\item \href{#method-pgu.correlator-printPSpearmanTbl}{\code{pgu.correlator$printPSpearmanTbl()}}
\item \href{#method-pgu.correlator-clone}{\code{pgu.correlator$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-pgu.correlator-new"></a>}}
\if{latex}{\out{\hypertarget{method-pgu.correlator-new}{}}}
\subsection{Method \code{new()}}{
Creates and returns a new `pgu.correlator` object.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{pgu.correlator$new(data = "tbl_df")}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{data}}{The data to be modeled.
(tibble::tibble)}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A new `pgu.correlator` object.
(pguIMP::pgu.correlator)
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-pgu.correlator-finalize"></a>}}
\if{latex}{\out{\hypertarget{method-pgu.correlator-finalize}{}}}
\subsection{Method \code{finalize()}}{
Clears the heap and
indicates if instance of `pgu.correlator` is removed from heap.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{pgu.correlator$finalize()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-pgu.correlator-print"></a>}}
\if{latex}{\out{\hypertarget{method-pgu.correlator-print}{}}}
\subsection{Method \code{print()}}{
Prints instance variables of a `pgu.correlator` object.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{pgu.correlator$print()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
string
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-pgu.correlator-resetCorrelator"></a>}}
\if{latex}{\out{\hypertarget{method-pgu.correlator-resetCorrelator}{}}}
\subsection{Method \code{resetCorrelator()}}{
Performes pair-wise correlation analysis on the attributes of the data frame.
Progresse is indicated by the progress object passed to the function.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{pgu.correlator$resetCorrelator(data = "tbl_df", progress = "Progress")}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{data}}{Dataframe with at least two numeric attributes.
(tibble::tibble)}

\item{\code{progress}}{Keeps track of the analysis progress.
(shiny::Progress)}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-pgu.correlator-resetMatrix"></a>}}
\if{latex}{\out{\hypertarget{method-pgu.correlator-resetMatrix}{}}}
\subsection{Method \code{resetMatrix()}}{
Creates a square matrix which dimension corresponds to the length
of the instance variable featureNames. The matrix entries are set to a distict `value`.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{pgu.correlator$resetMatrix(value = "numeric")}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{value}}{The value the matrix entries are set to.
(numeric)}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A square matrix.
(matrix)
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-pgu.correlator-featureIdx"></a>}}
\if{latex}{\out{\hypertarget{method-pgu.correlator-featureIdx}{}}}
\subsection{Method \code{featureIdx()}}{
Determines the numerical index of the column of an attribute based on the attribute name.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{pgu.correlator$featureIdx(feature = "character")}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{feature}}{The attribute's name.
(character)}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
The attributes column index.
(numeric)
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-pgu.correlator-calcCorrelationNumeric"></a>}}
\if{latex}{\out{\hypertarget{method-pgu.correlator-calcCorrelationNumeric}{}}}
\subsection{Method \code{calcCorrelationNumeric()}}{
Creates a correlation test between two attributes of a dataframe.
The test is stored as instance variable.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{pgu.correlator$calcCorrelationNumeric(
  abscissa = "numeric",
  ordinate = "numeric",
  method = "character"
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{abscissa}}{The abscissa values.
(numeric)}

\item{\code{ordinate}}{The ordinate values.
(numeric)}

\item{\code{method}}{The cname of the correlation test.
Valid coiced are defined by the instance variable `method`.
(chatacter)}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-pgu.correlator-createCorrelationMatrixPearson"></a>}}
\if{latex}{\out{\hypertarget{method-pgu.correlator-createCorrelationMatrixPearson}{}}}
\subsection{Method \code{createCorrelationMatrixPearson()}}{
Performs the actual correlation test routine after Pearson.
Iteratively runs through the attributes known to the class
and calculates Pearson's correlation for each valid attribute pair.
The test results are stored in the instance variables:
r, pPearson.
Here, pX represents the p-value of the respective parameter X.
Displays the progress if shiny is loaded.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{pgu.correlator$createCorrelationMatrixPearson(
  data = "tbl_df",
  progress = "Progress"
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{data}}{The data to be analysed.
(tibble::tibble)}

\item{\code{progress}}{If shiny is loaded, the analysis' progress is stored within this instance of the shiny Progress class.
(shiny::Progress)}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-pgu.correlator-createCorrelationMatrixKendall"></a>}}
\if{latex}{\out{\hypertarget{method-pgu.correlator-createCorrelationMatrixKendall}{}}}
\subsection{Method \code{createCorrelationMatrixKendall()}}{
Performs the actual correlation test routine after Kendall.
Iteratively runs through the attributes known to the class
and calculates Kendall's correlation for each valid attribute pair.
The test results are stored in the instance variables:
tau, pKendall.
Here, pX represents the p-value of the respective parameter X.
Displays the progress if shiny is loaded.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{pgu.correlator$createCorrelationMatrixKendall(
  data = "tbl_df",
  progress = "Progress"
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{data}}{The data to be analysed.
(tibble::tibble)}

\item{\code{progress}}{If shiny is loaded, the analysis' progress is stored within this instance of the shiny Progress class.
(shiny::Progress)}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-pgu.correlator-createCorrelationMatrixSpearman"></a>}}
\if{latex}{\out{\hypertarget{method-pgu.correlator-createCorrelationMatrixSpearman}{}}}
\subsection{Method \code{createCorrelationMatrixSpearman()}}{
Performs the actual correlation test routine after Spearman.
Iteratively runs through the attributes known to the class
and calculates Spearman's correlation for each valid attribute pair.
The test results are stored in the instance variables:
rho, pSpearman.
Here, pX represents the p-value of the respective parameter X.
Displays the progress if shiny is loaded.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{pgu.correlator$createCorrelationMatrixSpearman(
  data = "tbl_df",
  progress = "Progress"
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{data}}{The data to be analysed.
(tibble::tibble)}

\item{\code{progress}}{If shiny is loaded, the analysis' progress is stored within this instance of the shiny Progress class.
(shiny::Progress)}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-pgu.correlator-correlate"></a>}}
\if{latex}{\out{\hypertarget{method-pgu.correlator-correlate}{}}}
\subsection{Method \code{correlate()}}{
Performs the all three correlation test routines defined
within the instance variable `method`.
Displays the progress if shiny is loaded.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{pgu.correlator$correlate(data = "tbl_df", progress = "Progress")}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{data}}{The data to be analysed.
(tibble::tibble)}

\item{\code{progress}}{If shiny is loaded, the analysis' progress is stored within this instance of the shiny Progress class.
(shiny::Progress)}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-pgu.correlator-printFeature"></a>}}
\if{latex}{\out{\hypertarget{method-pgu.correlator-printFeature}{}}}
\subsection{Method \code{printFeature()}}{
Transforms the results of the correlation procedure for a valid pair of attributes to a dataframe
and returns it.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{pgu.correlator$printFeature()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
The analyis result as a dataframe.
(tibble::tibble)
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-pgu.correlator-printRTbl"></a>}}
\if{latex}{\out{\hypertarget{method-pgu.correlator-printRTbl}{}}}
\subsection{Method \code{printRTbl()}}{
Transfroms instance variable `r` to a dataframe and returns it.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{pgu.correlator$printRTbl()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
Dataframe of instance variable `r`.
(tibble::tibble)
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-pgu.correlator-printPPearsonTbl"></a>}}
\if{latex}{\out{\hypertarget{method-pgu.correlator-printPPearsonTbl}{}}}
\subsection{Method \code{printPPearsonTbl()}}{
Transfroms instance variable `pPearson` to a dataframe and returns it.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{pgu.correlator$printPPearsonTbl()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
Dataframe of instance variable `pPearson`.
(tibble::tibble)
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-pgu.correlator-printTauTbl"></a>}}
\if{latex}{\out{\hypertarget{method-pgu.correlator-printTauTbl}{}}}
\subsection{Method \code{printTauTbl()}}{
Transfroms instance variable `tau` to a dataframe and returns it.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{pgu.correlator$printTauTbl()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
Dataframe of instance variable `tau`.
(tibble::tibble)
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-pgu.correlator-printPKendallTbl"></a>}}
\if{latex}{\out{\hypertarget{method-pgu.correlator-printPKendallTbl}{}}}
\subsection{Method \code{printPKendallTbl()}}{
Transfroms instance variable `pKendall` to a dataframe and returns it.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{pgu.correlator$printPKendallTbl()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
Dataframe of instance variable `pKendall`.
(tibble::tibble)
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-pgu.correlator-printRhoTbl"></a>}}
\if{latex}{\out{\hypertarget{method-pgu.correlator-printRhoTbl}{}}}
\subsection{Method \code{printRhoTbl()}}{
Transfroms instance variable `rho` to a dataframe and returns it.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{pgu.correlator$printRhoTbl()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
Dataframe of instance variable `rho`.
(tibble::tibble)
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-pgu.correlator-printPSpearmanTbl"></a>}}
\if{latex}{\out{\hypertarget{method-pgu.correlator-printPSpearmanTbl}{}}}
\subsection{Method \code{printPSpearmanTbl()}}{
Transfroms instance variable `pSpearman` to a dataframe and returns it.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{pgu.correlator$printPSpearmanTbl()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
Dataframe of instance variable `pSpearman`.
(tibble::tibble)
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-pgu.correlator-clone"></a>}}
\if{latex}{\out{\hypertarget{method-pgu.correlator-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{pgu.correlator$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
