% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utilities.R
\name{mlocscale}
\alias{mlocscale}
\title{Compute the M-estimate of Location and Scale}
\usage{
mlocscale(
  x,
  bdp = 0.25,
  eff = 0.9,
  scale_cc,
  location_rho,
  location_cc,
  opts = mscale_algorithm_options()
)
}
\arguments{
\item{x}{numeric values. Missing values are verbosely ignored.}

\item{bdp}{desired breakdown point (between 0 and 0.5).}

\item{eff}{desired efficiency of the location estimate (between 0.1 and 0.99).}

\item{scale_cc}{tuning constant for the \eqn{\rho} function for computing the
scale estimate.
By default, chosen to yield a consistent estimate for normally distributed values.}

\item{location_rho}{\eqn{\rho} function for computing the location estimate.
If missing, use the same function as for the scale estimate (\code{opts$rho}).
See \code{\link[=rho_function]{rho_function()}} for a list of available \eqn{\rho} functions.}

\item{location_cc}{tuning constant for the location \eqn{\rho} function.
By default chosen to yield the desired efficiency.
If this is provided, the desired efficiency is ignored.}

\item{opts}{a list of options for the M-scale estimating equations,
See \code{\link[=mscale_algorithm_options]{mscale_algorithm_options()}} for details.}
}
\value{
a vector with 2 elements, the M-estimate of location and the M-scale estimate.
}
\description{
Simultaneous estimation of the location and scale by means of M-estimates.
}
\seealso{
Other functions to compute robust estimates of location and scale: 
\code{\link{mloc}()},
\code{\link{mscale}()},
\code{\link{tau_size}()}
}
\concept{functions to compute robust estimates of location and scale}
