% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stats.R
\name{batch_mediate}
\alias{batch_mediate}
\title{Batch mediate}
\usage{
batch_mediate(data, mediator_df, nsims = 500, conf.level = 0.95)
}
\arguments{
\item{data}{data.frame with two columns: X (independent variable) and Y (dependent variable).}

\item{mediator_df}{data.frame with mediators, each column representing a different mediator variable.}

\item{nsims}{Number of bootstrap simulations for estimating confidence intervals (default is 500).}

\item{conf.level}{Confidence level for the confidence intervals (default is 0.95).}
}
\value{
data.frame
}
\description{
Batch mediate
}
\examples{
set.seed(123)
n <- 200
X <- rnorm(n)
M1 <- 0.5 * X + rnorm(n)
M2 <- 0.3 * X + rnorm(n)
M3 <- 0.1 * X + rnorm(n)
Y <- 0.3 * X + 0.4 * M1 + 0.2 * M2 + rnorm(n)
data <- data.frame(X, Y)
mediators <- data.frame(M1, M2, M3)
if (requireNamespace("mediation")) {
  results <- batch_mediate(data, mediators, nsims = 99)
  print(results)
}
}
