% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/augment.R
\name{augment.model_fit}
\alias{augment.model_fit}
\title{Augment data with predictions}
\usage{
\method{augment}{model_fit}(x, new_data, eval_time = NULL, ...)
}
\arguments{
\item{x}{A \link[=model_fit]{model fit} produced by \code{\link[=fit.model_spec]{fit.model_spec()}} or
\code{\link[=fit_xy.model_spec]{fit_xy.model_spec()}}.}

\item{new_data}{A data frame or matrix.}

\item{eval_time}{For censored regression models, a vector of time points at
which the survival probability is estimated.}

\item{...}{Not currently used.}
}
\description{
\code{augment()} will add column(s) for predictions to the given data.
}
\details{
\subsection{Regression}{

For regression models, a \code{.pred} column is added. If \code{x} was created using
\code{\link[=fit.model_spec]{fit.model_spec()}} and \code{new_data} contains a regression outcome column, a
\code{.resid} column is also added.
}

\subsection{Classification}{

For classification models, the results can include a column called
\code{.pred_class} as well as class probability columns named \verb{.pred_\{level\}}.
This depends on what type of prediction types are available for the model.
}

\subsection{Censored Regression}{

For these models, predictions for the expected time and survival probability
are created (if the model engine supports them). If the model supports
survival prediction, the \code{eval_time} argument is required.

If survival predictions are created and \code{new_data} contains a
\code{\link[survival:Surv]{survival::Surv()}} object, additional columns are added for inverse
probability of censoring weights (IPCW) are also created (see \code{tidymodels.org}
page in the references below). This enables the user to compute performance
metrics in the \pkg{yardstick} package.
}

\subsection{Quantile Regression}{

For quantile regression models, a \code{.pred_quantile} column is added that
contains the quantile predictions for each row. This column has a special
class \code{"quantile_pred"} and can be unnested using \code{\link[tidyr:unnest]{tidyr::unnest()}}
}
}
\examples{
\dontshow{if (!parsnip:::is_cran_check() & rlang::is_installed("modeldata")) withAutoprint(\{ # examplesIf}
car_trn <- mtcars[11:32,]
car_tst <- mtcars[ 1:10,]

reg_form <-
  linear_reg() |>
  set_engine("lm") |>
  fit(mpg ~ ., data = car_trn)
reg_xy <-
  linear_reg() |>
  set_engine("lm") |>
  fit_xy(car_trn[, -1], car_trn$mpg)

augment(reg_form, car_tst)
augment(reg_form, car_tst[, -1])

augment(reg_xy, car_tst)
augment(reg_xy, car_tst[, -1])

# ------------------------------------------------------------------------------

data(two_class_dat, package = "modeldata")
cls_trn <- two_class_dat[-(1:10), ]
cls_tst <- two_class_dat[  1:10 , ]

cls_form <-
  logistic_reg() |>
  set_engine("glm") |>
  fit(Class ~ ., data = cls_trn)
cls_xy <-
  logistic_reg() |>
  set_engine("glm") |>
  fit_xy(cls_trn[, -3],
  cls_trn$Class)

augment(cls_form, cls_tst)
augment(cls_form, cls_tst[, -3])

augment(cls_xy, cls_tst)
augment(cls_xy, cls_tst[, -3])

# ------------------------------------------------------------------------------

if (rlang::is_installed("quantreg")) {
  # Quantile regression example
  qr_form <-
    linear_reg() |>
    set_engine("quantreg") |>
    set_mode("quantile regression", quantile_levels = c(0.25, 0.5, 0.75)) |>
    fit(mpg ~ ., data = car_trn)

  augment(qr_form, car_tst)
  augment(qr_form, car_tst[, -1])
}
\dontshow{\}) # examplesIf}
}
\references{
\url{https://www.tidymodels.org/learn/statistics/survival-metrics/}
}
