% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/parsers_basic.R
\name{satisfy}
\alias{satisfy}
\title{Matching input using a logical function}
\usage{
satisfy(b, expected = "matching input")
}
\arguments{
\item{b}{a boolean function to determine if the string is accepted.}

\item{expected}{character string describing what is expected (for error messages).}
}
\value{
A parser.
}
\description{
\code{satisfy()} turns a logical function into a parser that recognizes strings.
}
\details{
Notice (see pseudocode) that \code{satisfy} fails when presented with empty
input, so it is futile to write predicate functions that would recognize
such input.
}
\section{Pseudocode}{

\preformatted{
satisfy(b)(x):
  if x==null then fail()(x)
  else if b(x[1]) then succeed(x[1])(x[-1]) else fail()(x)
}

where \code{x[1]} is the first element of \code{x}, \code{x[-1]} all subsequent elements
(or \code{null} if it only has one element). \code{null} is the empty vector,
equivalent to \code{character(0)} in R.
}

\examples{
# define a predicate function that tests whether the next element starts
# with an 'a'
starts_with_a <- function(x) grepl("^a", x)
# Use it in the satisfy parser
satisfy(starts_with_a)(c("abc", "def")) # success
satisfy(starts_with_a)(c("bca", "def")) # failure
# Using an anonymous function
satisfy(function(x) {
  as.numeric(x) > 10
})("15") # success

}
