% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/marker.R
\name{print.marker}
\alias{print.marker}
\title{Print method for an object of class \code{marker}}
\usage{
\method{print}{marker}(x, ...)
}
\arguments{
\item{x}{an object used to select a method.}

\item{...}{further arguments passed to or from other methods.}
}
\value{
The printed \code{marker} object is returned invisibly.
}
\description{
An object of class \code{marker} is an empty list created by the function
\code{fail()}. To indicate that this object differs from simply \code{list()} its
print method prints \verb{[]}.
}
\details{
The \code{marker} class is used internally to mark the largest index number of
the element (i.e. line) of the input character vector at which the parser
failed. This number is stored in the attribute \code{n} of a marker and only
correctly corresponds to that index number if the parser is wrapped in a
\code{\link[=reporter]{reporter()}} call.
}
\examples{
d <- (literal("A") \%then\% literal("B"))(c("A", "A"))
# prints the icon [] for failed parsing
d
# Reveal the modest content of the marker object
unclass(d)
}
\seealso{
\code{\link[=failed]{failed()}}
}
