% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/api-affiliations.R
\name{orcid_distinctions}
\alias{orcid_distinctions}
\title{Retrieve distinctions from ORCID}
\usage{
orcid_distinctions(orcid_id, token = NULL)
}
\arguments{
\item{orcid_id}{Character string. A valid ORCID identifier in the format
XXXX-XXXX-XXXX-XXXX. Can also handle URLs like https://orcid.org/XXXX-XXXX-XXXX-XXXX.}

\item{token}{Character string or NULL. Optional API token for authenticated
requests. If NULL (default), checks the ORCID_TOKEN environment variable.}
}
\value{
A data.table with the following columns:
\describe{
\item{orcid}{ORCID identifier}
\item{put_code}{Unique identifier for this distinction record}
\item{organization}{Name of the awarding organization}
\item{department}{Department name (if available)}
\item{role}{Award or distinction title}
\item{start_date}{Award/distinction date (ISO format)}
\item{end_date}{End date (ISO format, if applicable)}
\item{city}{City of organization}
\item{region}{State/region of organization}
\item{country}{Country of organization}
}
Returns an empty data.table with the same structure if no distinction
records are found.
}
\description{
Fetches distinction records (awards, honors, recognitions) for an ORCID
identifier. Returns structured data similar to employments and educations.
}
\details{
This function queries the ORCID public API endpoint:
\code{https://pub.orcid.org/v3.0/{orcid-id}/distinctions}
}
\examples{
\dontrun{
# Fetch distinctions
distinctions <- orcid_distinctions("0000-0002-1825-0097")
print(distinctions)
}

}
\references{
ORCID API Documentation: \url{https://info.orcid.org/documentation/api-tutorials/}
}
\seealso{
\code{\link{orcid_employments}}, \code{\link{orcid_educations}}, \code{\link{orcid_activities}}
}
