% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/class-workbook-wrappers.R
\name{wb_add_style}
\alias{wb_add_style}
\title{Register a style in a workbook}
\usage{
wb_add_style(wb, style = NULL, style_name = NULL)
}
\arguments{
\item{wb}{A \link{wbWorkbook} object.}

\item{style}{A character string containing the XML definition of the style.
This is usually the output of functions like \code{\link[=create_cell_style]{create_cell_style()}} or
\code{\link[=create_dxfs_style]{create_dxfs_style()}}.}

\item{style_name}{Optional; a unique name for the style. If \code{NULL}, the
function attempts to derive a name from the object name or the internal
XML attributes (e.g., for table styles).}
}
\value{
The \link{wbWorkbook} object, invisibly.
}
\description{
The \code{wb_add_style()} function serves as a general-purpose entry point for
registering XML-based style definitions into a \code{wbWorkbook}. While specific
wrappers like \code{\link[=wb_add_font]{wb_add_font()}} target individual cell properties, \code{wb_add_style()}
is used to add pre-constructed styles—such as custom table styles or
differential formatting (DXF) styles—to the workbook's internal style manager.
}
\details{
Styles in the OpenXML specification are stored in a centralized catalog
(\code{styles.xml}). This function takes an XML character string, typically
generated by a \verb{create_*()} function, and registers it under a specific
\code{style_name}.

Once registered, these styles can be applied to cells, ranges, or tables
by referencing their name. This is particularly useful for maintaining
consistency across a large workbook or when creating complex "Table Styles"
that define headers, footers, and banding in a single object.
}
\section{Notes}{

\itemize{
\item If the \code{style} provided is a \code{tableStyle} node, the function automatically
extracts the name from the XML attribute if \code{style_name} is not provided.
\item Registering a style does not automatically apply it to a cell; it only
makes the style available within the workbook's style catalog.
}
}

\examples{
yellow_f <- wb_color(hex = "FF9C6500")
yellow_b <- wb_color(hex = "FFFFEB9C")

yellow <- create_dxfs_style(font_color = yellow_f, bg_fill = yellow_b)
wb <- wb_workbook()
wb <- wb_add_style(wb, yellow)
}
\seealso{
\itemize{
\item \code{\link[=create_border]{create_border()}}
\item \code{\link[=create_cell_style]{create_cell_style()}}
\item \code{\link[=create_dxfs_style]{create_dxfs_style()}}
\item \code{\link[=create_fill]{create_fill()}}
\item \code{\link[=create_font]{create_font()}}
\item \code{\link[=create_numfmt]{create_numfmt()}}
}

Other workbook styling functions: 
\code{\link{base_font-wb}},
\code{\link{wb_add_dxfs_style}()},
\code{\link{wb_base_colors}}
}
\concept{workbook styling functions}
