% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fetch_vd_meta.R
\name{fetch_vd_meta}
\alias{fetch_vd_meta}
\title{Fetch VecDyn metadata table}
\usage{
fetch_vd_meta(
  ids = NULL,
  cache_location = NULL,
  refresh_cache = FALSE,
  noprogress = FALSE,
  basereq = vb_basereq()
)
}
\arguments{
\item{ids}{a numeric ID or numeric vector of ids (preferably in an \code{ohvbd.ids} object) indicating the particular dataset/s to download.}

\item{cache_location}{path to cache location (defaults to a temporary user directory, or one set by \code{\link[=set_default_ohvbd_cache]{set_default_ohvbd_cache()}}).}

\item{refresh_cache}{force a refresh of the relevant cached data.}

\item{noprogress}{disable non-essential messaging (progress bars etc.).}

\item{basereq}{an \link[httr2:request]{httr2 request} object, as generated by \code{\link[=vb_basereq]{vb_basereq()}}. If \code{NA}, uses the default request.}
}
\value{
A dataframe describing the current VecDyn metadata.
}
\description{
Fetch VecDyn metadata table (downloading if necessary) and cache if fresh.
}
\examples{
\dontshow{if (interactive()) withAutoprint(\{ # examplesIf}
fetch_vd_meta_table()
\dontshow{\}) # examplesIf}
}
\author{
Francis Windram
}
\concept{internal}
