% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summary.R
\name{failed_pairs}
\alias{failed_pairs}
\title{Get Failed Comparisons from Batch Results}
\usage{
failed_pairs(object)
}
\arguments{
\item{object}{An \code{odiffr_batch} object from \code{\link[=compare_images_batch]{compare_images_batch()}} or
\code{\link[=compare_image_dirs]{compare_image_dirs()}}.}
}
\value{
A tibble or data.frame containing only rows where \code{match} is \code{FALSE}.
}
\description{
Extract only the failed (non-matching) comparisons from batch results.
}
\examples{
\dontrun{
results <- compare_image_dirs("baseline/", "current/")
failed <- failed_pairs(results)
nrow(failed)  # Number of failures
}
}
\seealso{
\code{\link[=compare_images_batch]{compare_images_batch()}}, \code{\link[=compare_image_dirs]{compare_image_dirs()}}, \code{\link[=passed_pairs]{passed_pairs()}}
}
