print.np.cdf.test <-
  function(x, digits = 4, n = 10, ...){
    
    univar <- is.null(x$univariate)
    statistic <- paste("omega^2 =", round(x$statistic, digits))
    p.value <- round(x$p.value, digits)
    onesamp <- ifelse(substr(x$method, 1, 3) == "One", TRUE, FALSE)
    
    # print info
    if(univar){
      cat("\n", x$method, "\n", sep = "")
    } else {
      cat("\n", "Multivariate ", x$method, "\n", sep = "")
    }
    if(onesamp) {
      cat("null hypothesis:  Fx =", paste0("p", x$nulldist), "\n")
    } else {
      cat("null hypothesis:  Fx = Fy\n")
    }
    cat(statistic, ",  p-value = ", p.value, "\n", sep = "")
    cat("\n")
    
  }