% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ga.cores.R
\name{ga.crossover}
\alias{ga.crossover}
\title{Crossover operator (one- or two-point) for binary chromosomes}
\usage{
ga.crossover(sel.population, pcross, npop, nbits)
}
\arguments{
\item{sel.population}{Numeric matrix of dimension npop by nbits. Each row is a
chromosome and is expected to contain binary values (0/1).}

\item{pcross}{Single numeric value in \eqn{[0, 1]} giving the probability of applying
crossover to each parent pair.}

\item{npop}{Single positive even integer giving the population size.}

\item{nbits}{Single positive integer giving the chromosome length.}
}
\value{
Numeric matrix containing the children population after crossover.
}
\description{
Apply one- or two-point crossover to a selected population of binary chromosomes.
}
\details{
Parents are paired sequentially (1 with 2, 3 with 4, etc.). For each pair,
crossover is applied with probability \code{pcross}; otherwise the parents are copied
unchanged. Crossover points are sampled from 0:\code{nbits}. If the sampled points do
not yield a valid crossover, no crossover is performed for that pair.
}
\examples{
sel.population <- matrix(sample(0:1, 100, replace = TRUE), nrow = 10)
ga.crossover(sel.population = sel.population, pcross = 0.7, npop = 10, nbits = 10)

}
\author{
Zhonghui Huang
}
