% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/base.model.R
\name{base_model}
\alias{base_model}
\title{Create a base model code for single-start model search algorithms}
\usage{
base_model(search.space = "ivbase")
}
\arguments{
\item{search.space}{Character, one of "ivbase" or "oralbase". Default is "ivbase".}
}
\value{
For search.space = "ivbase": a named integer vector of length 9 containing:
\itemize{
\item no.cmpt   - Number of compartments
\item eta.km    - IIV flag for \eqn{K_m}
\item eta.vc    - IIV flag for \eqn{V_c}
\item eta.vp    - IIV flag for \eqn{V_p}
\item eta.vp2   - IIV flag for \eqn{V_{p2}}
\item eta.q     - IIV flag for \eqn{Q}
\item eta.q2    - IIV flag for \eqn{Q_2}
\item mm        - Michaelis–Menten term flag
\item mcorr     - Correlation flag among ETAs
\item rv        - Residual error model code
}

For search.space = "oralbase": a named integer vector of length 11, including
all fields above plus:
\itemize{
\item eta.ka    - IIV flag for \eqn{k_a} (oral absorption rate constant)
}
}
\description{
Constructs a named numeric vector defining the initial structural and
inter-individual variability model configuration used in single-start
automated PK model search algorithms.
}
\details{
Two search spaces are supported: "ivbase" and "oralbase". A user-specified
initial model code can be provided via the custom_base argument. The input is
validated for numerical type and expected length, and standardized element
names are applied before returning. The function is currently used in
stepwise selection and tabu search routines, where a single starting model
is iteratively updated.
}
\examples{
base_model("ivbase")
base_model("oralbase")
}
\author{
Zhonghui Huang
}
