% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/super_learner.R
\name{super_learner}
\alias{super_learner}
\title{Super Learner: Cross-Validation Based Ensemble Learning}
\usage{
super_learner(
  data,
  learners,
  formulas,
  y_variable = NULL,
  n_folds = 5,
  determine_super_learner_weights,
  ensemble_or_discrete = "ensemble",
  cv_schema,
  outcome_type = "continuous",
  extra_learner_args = NULL,
  cluster_ids = NULL,
  strata_ids = NULL,
  weights = NULL,
  use_complete_cases = FALSE
)
}
\arguments{
\item{data}{Data to use in training a \code{super_learner}.}

\item{learners}{A list of predictor/closure-returning-functions. See Details.}

\item{formulas}{Either a single regression formula or a vector of regression formulas.}

\item{y_variable}{Typically \code{y_variable} can be inferred automatically from the \code{formulas}, but if needed, the y_variable can be specified explicitly.}

\item{n_folds}{The number of cross-validation folds to use in constructing the \code{super_learner}.}

\item{determine_super_learner_weights}{A function/method to determine the weights for each of the candidate \code{learners}. The default is to use \code{determine_super_learner_weights_nnls}.}

\item{ensemble_or_discrete}{Defaults to \code{'ensemble'}, but can be set to \code{'discrete'}. Discrete \code{super_learner()} chooses only one of the candidate learners to have weight 1 in the resulting prediction algorithm,
while \code{ensemble} \code{super_learner()} combines predictions from 1 or more candidate learners, with respective weights adding up to 1.}

\item{cv_schema}{A function that takes \code{data}, \code{n_folds} and returns a list containing \code{training_data} and \code{validation_data}, each of which are lists of \code{n_folds} data frames.}

\item{outcome_type}{One of 'continuous', 'binary', 'multiclass', or 'density'. \code{outcome_type} is used to infer the correct \code{determine_super_learner_weights} function if it is not explicitly passed.}

\item{extra_learner_args}{A list of equal length to the \code{learners} with additional arguments to pass to each of the specified learners.}

\item{cluster_ids}{(default: null) If specified, clusters will either be entirely assigned to training or validation (not both) in each cross-validation split.}

\item{strata_ids}{(default: null) If specified, strata are balanced across training and validation splits so that strata appear in both the training and validation splits.}

\item{weights}{If specified, (per observation) weights are used to
indicate that risk minimization across models (i.e., the meta-learning
step) should be targeted to higher weight observations.}

\item{use_complete_cases}{(default: FALSE) If the \code{data} passed have any NA or NaN missing data, restrict the \code{data} to
\code{data[complete.cases(data),]}.}
}
\value{
An object of class inheriting from \code{nadir_sl_model}. This is an S3 object,
with elements including a \code{$predict(newdata)} method, and some information
about the fit model including \code{y_variable}, \code{outcome_type}, \code{learner_weights},
\code{holdout_predictions} and optionally information about any errors thrown by the
learner fitting process.
}
\description{
Super learning with functional programming!
}
\details{
The goal of any super learner is to use cross-validation and a
set of candidate learners to 1) evaluate how the learners perform
on held out data and 2) to use that evaluation to produce a weighted
average (for continuous super learner) or to pick a best learner (for
discrete super learner) of the specified candidate learners.

Super learner and its statistically desirable properties have been written
about at length, including at least the following references:
\itemize{
\item \url{https://biostats.bepress.com/ucbbiostat/paper222/}
\item \url{https://www.stat.berkeley.edu/users/laan/Class/Class_subpages/BASS_sec1_3.1.pdf}
}

\code{nadir::super_learner} adopts several user-interface design-perspectives
that will be useful to know in understanding what it does and how it works:
\itemize{
\item The specification of learners should be \emph{very flexible}, really only
constrained by the fact that candidate learners should be designed
for the same prediction problem but their details can wildly vary
from learner to learner.
\item It should be easy to specify a customized or new learner.
}

\code{nadir::super_learner} at its core accepts \code{data},
a \code{formula} (a single one passed to \code{formulas} is fine),
and a list of \code{learners}.

\code{learners} are taken to be lists of functions of the following specification:
\itemize{
\item a learner must accept a \code{data} and \code{formula} argument,
\item a learner may accept more arguments, and
\item a learner must return a prediction function that accepts \code{newdata} and
produces a vector of prediction values given \code{newdata}.
}

In essence, a learner is specified to be a function taking (\code{data}, \code{formula}, ...)
and returning a \emph{closure} (see \url{http://adv-r.had.co.nz/Functional-programming.html#closures} for an introduction to closures)
which is a function accepting \code{newdata} returning predictions.

Since many candidate learners will have hyperparameters that should be tuned,
like depth of trees in random forests, or the \code{lambda} parameter for \code{glmnet},
extra arguments can be passed to each learner via the \code{extra_learner_args}
argument. \code{extra_learner_args} should be a list of lists, one list of
extra arguments for each learner. If no additional arguments are needed
for some learners, but some learners you're using do require additional
arguments, you can just put a \code{NULL} value into the \code{extra_learner_args}.
See the examples.

In order to seamlessly support using features implemented by extensions
to the formula syntax (like random effects formatted like random intercepts or slopes that use the
\code{(age | strata)} syntax in
\code{lme4} or splines like \code{s(age | strata)} in \code{mgcv}), we allow for the
\code{formulas} argument to either be one fixed formula that
\code{super_learner} will use for all the models, or a vector of formulas,
one for each learner specified.

Note that in the examples a mean-squared-error (mse) is calculated on
the same training/test set, and this is only useful as a crude diagnostic to
see that super_learner is working. A more rigorous performance metric to
evaluate \code{super_learner} on is the cv-rmse produced by cv_super_learner.
}
\examples{

learners <- list(
     glm = lnr_glm,
     rf = lnr_rf,
     glmnet = lnr_glmnet,
     lmer = lnr_lmer
  )

# mtcars example ---
formulas <- c(
  .default = mpg ~ cyl + hp, # first three models use same formula
  lmer = mpg ~ (1 | cyl) + hp # lme4 uses different language features
  )

# fit a super_learner
sl_model <- super_learner(
  data = mtcars,
  formula = formulas,
  learners = learners)

# We recommend taking a look at this object to see what's contained inside it:
sl_model

compare_learners(sl_model)

# iris example ---
sl_model <- super_learner(
  data = iris,
  formula = list(
    .default = Sepal.Length ~ Sepal.Width + Petal.Length + Petal.Width,
    lmer = Sepal.Length ~ (Sepal.Width | Species) + Petal.Length),
  learners = learners)

# produce super_learner predictions and compare against the individual learners
compare_learners(sl_model)

}
\seealso{
predict.nadir_sl_model compare_learners

cv_super_learner
}
