% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/derivatives.R
\name{hessian}
\alias{hessian}
\title{Compute the Hessian of a scalar-valued function}
\usage{
hessian(f, x)
}
\arguments{
\item{f}{A function taking a parameter vector and returning a scalar.}

\item{x}{A numeric vector of parameter values.}
}
\value{
A \code{p x p} numeric matrix (the Hessian).
}
\description{
Computes the matrix of second partial derivatives of \code{f} at \code{x}
using forward-mode AD. Equivalent to \code{D(f, x, order = 2)}.
}
\examples{
f <- function(x) -(x[1] - 3)^2 - (x[2] - 5)^2
hessian(f, c(1, 2))
}
