% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dual-higher.R
\name{dual_variable_n}
\alias{dual_variable_n}
\title{Create a dual seeded for n-th order differentiation}
\usage{
dual_variable_n(x, order)
}
\arguments{
\item{x}{A numeric value at which to differentiate.}

\item{order}{A positive integer specifying the derivative order.}
}
\value{
A (possibly nested) dual number.
}
\description{
Recursively nests dual numbers to enable exact computation of
derivatives up to order \code{n}. The variable is seeded so that
after evaluating a function \code{f}, the k-th derivative can be
extracted with \code{deriv_n(result, k)}.
}
\examples{
x <- dual_variable_n(2, order = 3)
r <- x^4
deriv_n(r, 3)
}
