% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/derivatives.R
\name{D}
\alias{D}
\title{Composable total derivative operator}
\usage{
D(f, x = NULL, order = 1L)
}
\arguments{
\item{f}{A function taking a parameter vector (via \code{x[i]} indexing)
and returning a scalar, list, or \code{dual_vector}.}

\item{x}{Optional numeric vector. If provided, evaluates \code{D(f)(x)}.}

\item{order}{Derivative order (default 1). \code{order = k} applies
\code{D} k times.}
}
\value{
If \code{x} is \code{NULL}, a function. Otherwise, a numeric
vector, matrix, or array of the appropriate tensor shape.
}
\description{
\code{D(f)} returns the derivative of \code{f} as a new function.
\code{D(f, x)} evaluates the derivative at \code{x}.
\code{D(D(f))} composes for second-order derivatives, and so on.
}
\details{
Each application of \code{D} appends one \code{n}-dimension to the output
shape, where \code{n = length(x)}:
\itemize{
\item For \code{f: R^n -> R}: D gives \code{(n)} gradient, D^2 gives
\code{(n,n)} Hessian, D^3 gives \code{(n,n,n)}, etc.
\item For \code{f: R^n -> R^m}: D gives \code{(m,n)} Jacobian, D^2 gives
\code{(m,n,n)}, etc.
}

The composability works because the S4 dispatch for \code{dualr} arithmetic
handles nested duals recursively. When \code{D(f)} is called with dual
inputs (from an outer \code{D}), derivative propagation is automatic.

\code{gradient()}, \code{hessian()}, and \code{jacobian()} are convenience
wrappers: \code{gradient(f, x)} is \code{D(f, x)}, \code{hessian(f, x)} is
\code{D(f, x, order = 2)}, and \code{jacobian(f, x)} is \code{D(f, x)}.
}
\examples{
f <- function(x) x[1]^2 * x[2]
D(f, c(3, 4))
D(f, c(3, 4), order = 2)

g <- function(x) list(x[1] * x[2], x[1]^2)
D(g, c(2, 3))

Df <- D(f)
DDf <- D(Df)
DDf(c(3, 4))
}
