% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/contactMatrixPolymod.R
\name{contactMatrixPolymod}
\alias{contactMatrixPolymod}
\title{Calculate a contact matrix for age groups based on Polymod contact survey data}
\usage{
contactMatrixPolymod(agelims, agepops = NULL)
}
\arguments{
\item{agelims}{minimum age in years for each age group. The maximum valid
age limit is 90, as the socialmixr contact_matrix function supports ages
up to 90. Age limits greater than 90 will be replaced with 90 and a
warning will be issued.}

\item{agepops}{population size of each group, defaulting to demography of
Polymod survey population. If provided, must match the length of the
age groups defined by \code{agelims} (after any adjustments for exceeding
the 90-year limit).}
}
\value{
A symmetric contact matrix with row and column names indicating
the age groups.
}
\description{
Calculate a contact matrix for age groups based on Polymod contact survey data
}
\details{
The socialmixr contact_matrix function supports age limits up to 90.
Any age limits above 90 will be adjusted to 90 with a warning, and the
corresponding populations will be aggregated into a single "90+" group.
}
\examples{
#Default population distribution uses population data from POLYMOD survey locations:
contactMatrixPolymod(agelims = c(0, 5, 18))
#Specifying the age distribution will lead to an adjusted version:
contactMatrixPolymod(agelims = c(0, 5, 18), agepops = c(500, 1300, 8200))
}
