% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generics.R, R/generics_lavaan.R,
%   R/generics_modsem_da.R, R/generics_modsem_mplus.R, R/generics_modsem_pi.R
\name{standardized_estimates}
\alias{standardized_estimates}
\alias{standardized_estimates.lavaan}
\alias{standardized_estimates.modsem_da}
\alias{standardized_estimates.modsem_mplus}
\alias{standardized_estimates.modsem_pi}
\title{Get Standardized Estimates}
\usage{
standardized_estimates(object, ...)

\method{standardized_estimates}{lavaan}(
  object,
  monte.carlo = FALSE,
  mc.reps = 10000,
  tolerance.zero = 1e-10,
  ...
)

\method{standardized_estimates}{modsem_da}(
  object,
  monte.carlo = FALSE,
  mc.reps = 10000,
  tolerance.zero = 1e-10,
  rm.tmp.ov = TRUE,
  ...
)

\method{standardized_estimates}{modsem_mplus}(object, type = "stdyx", mc.reps = 1e+06, ...)

\method{standardized_estimates}{modsem_pi}(
  object,
  correction = FALSE,
  std.errors = c("rescale", "delta", "monte.carlo"),
  mc.reps = 10000,
  colon.pi = FALSE,
  ...
)
}
\arguments{
\item{object}{An object of class \code{\link{modsem_da}}, \code{\link{modsem_mplus}},
\code{\link{modsem_pi}}, or a parameter table (\code{parTable}) of class \code{data.frame}.}

\item{...}{Additional arguments passed on to \code{lavaan::standardizedSolution()}.}

\item{monte.carlo}{Logical. If \code{TRUE}, use Monte Carlo simulation to estimate
standard errors; if \code{FALSE}, use the delta method (default).}

\item{mc.reps}{Integer. Number of Monte Carlo replications to use if \code{std.errors = "monte.carlo"}.}

\item{tolerance.zero}{Threshold below which standard errors are set to \code{NA}.}

\item{rm.tmp.ov}{Should temporary (hidden) variables be removed?}

\item{type}{Type of standardized estimates to retrieve. Can be one of: \code{"stdyx", "stdy", "std", "un", "modsem"}.}

\item{correction}{Logical. Whether to apply a correction to the standardized estimates
of the interaction term. By default, \code{FALSE}, which standardizes the interaction term
such that \eqn{\sigma^2(XZ) = 1}, consistent with \code{lavaan}'s treatment of latent interactions.
This is usually wrong, as it does not account for the fact that the interaction term
is a product of two variables, which means that the variance of the interaction term
of standardized variables (usually) is not equal to 1.

Hence the scale of the interaction effect changes, such that
the standardized interaction term does not correspond to one (standardized) unit
change in the moderating variables. If \code{TRUE}, a correction is applied by
computing the interaction term \eqn{b_3 = \frac{B_3 \sigma(X) \sigma(Z)}{\sigma(Y)}} (where
\eqn{B_3} is the unstandardized coefficient for the interaction term), and solving for \eqn{\sigma(XZ)}, which
is used to correct the variance of the interaction term, and its covariances.}

\item{std.errors}{Character string indicating the method used to compute standard errors
when \code{correction = TRUE}. Options include:
\describe{
  \item{"rescale"}{Simply rescales the standard errors. Fastest option.}
  \item{"delta"}{Uses the delta method to approximate standard errors.}
  \item{"monte.carlo"}{Uses Monte Carlo simulation to estimate standard errors.}
}
Ignored if \code{correction = FALSE}.}

\item{colon.pi}{Logical. If \code{TRUE}, the interaction terms in the output will be
will be formatted using \code{:} to seperate the elements in the interaction term. Default
is \code{FALSE}, using the default formatting from \code{lavaan}. Only relevant if
\code{std.errors != "rescale"} and \code{correction = TRUE}.}
}
\value{
A \code{data.frame} with standardized estimates in the \code{est} column.
}
\description{
Computes standardized estimates of model parameters for various types of \code{\link{modsem}} objects.
}
\details{
Standard errors can either be calculated using the delta method, or a monte.carlo simulation
  (\code{monte.carlo} is not available for \code{\link{modsem_pi}} objects if \code{correction == FALSE}.).
  \strong{NOTE} that the standard errors of the standardized paramters change the assumptions of the
  model, and will in most cases yield different z and p-values, compared to the unstandardized solution.
  In almost all cases, significance testing should be based on the unstandardized solution. Since,
  the standardization process changes the model assumptions, it also changes what the p-statistics measure.
  I.e., the test statistics for the standardized and unstandardized solutions belong to different sets of
  hypothesis, which are not exactly equivalent to each other.

For \code{modsem_da} and \code{modsem_mplus} objects, the interaction term is not a formal
 variable in the model and therefore lacks a defined variance. Under assumptions of normality
 and zero-mean variables, the interaction variance is estimated as:
 \deqn{var(xz) = var(x) * var(z) + cov(x, z)^2}
 This means the standardized estimate for the interaction differs from approaches like
 \code{lavaan}, which treats the interaction as a latent variable with unit variance.

For \code{modsem_pi} objects, the interaction term is standardized by default assuming
 \code{var(xz) = 1}, but this can be overridden using the \code{correction} argument.

\strong{NOTE:} Standardized estimates are always placed in the \strong{\code{est}} column,
not \code{est.std}, regardless of model type.
}
\section{Methods (by class)}{
\itemize{
\item \code{standardized_estimates(lavaan)}: Method for \code{lavaan} objects

\item \code{standardized_estimates(modsem_da)}: Method for \code{modsem_da} objects

\item \code{standardized_estimates(modsem_mplus)}: Retrieve standardized estimates from \code{\link{modsem_mplus}} object.

\item \code{standardized_estimates(modsem_pi)}: Method for \code{modsem_pi} objects

}}
\examples{
m1 <- '
  # Outer Model
  X =~ x1 + x2 + x3
  Z =~ z1 + z2 + z3
  Y =~ y1 + y2 + y3

  # Inner Model
  Y ~ X + Z + X:Z
'
# Double centering approach
est_dca <- modsem(m1, oneInt)

std1 <- standardized_estimates(est_dca) # no correction
summarize_partable(std1)

std2 <- standardized_estimates(est_dca, correction = TRUE) # apply correction
summarize_partable(std2)

\dontrun{
est_lms <- modsem(m1, oneInt, method = "lms")
standardized_estimates(est_lms) # correction not relevant for lms
}

}
