## Report Function
utils::globalVariables(c("x"))

#' Creates a report for a specific performance criterion from a miebl output
#'
#' @param mb object produced by miebl
#' @param X Number of correct responses for the performance criterion
#' @param mc performance criterion expressed as percent e.g. 90% performance criterion is 90
#'
#'
#' @return a report on the performance criterion selected with respect to the true mastery level desired
#' @export
#'
#' @examples
#' #create a miebl output for default 90% desired true mastery
#' xx<-miebl(10)
#' #Uses the miebl output for miebl_re for 90% performance criterion
#' miebl_re(xx,mc=90)

miebl_re<-function(mb,X=nrow(mb)-1,mc=100){
  rt<-min(X,ceiling(mc/100*(nrow(mb[[1]])-1)))
  mx<-rt/(nrow(mb[[1]])-1)*100
  rx<-mb[[1]][mb[[1]]$`# Correct`==rt,]
  am<-round(rx$post_s1/(rx$post_s1+rx$post_s2),4)
  st1<-(paste0("Performance criterion of ",mx,"% (",rt," out of ",(nrow(mb[[1]])-1)," items)"))
  st11<-("If the student meets this criterion, then:")
  st2<-(paste0("The probability that the true mastery is at least ",mb[[2]]$tr*100,"% is ",rx$b,"."))
  st3<-(paste0("We are ",(1-mb[[2]]$a)*100,"% confident that the true mastery is at least ",as.numeric(rx$lb)*100,"%."))
  st4<-(paste0("There is a ",(1-mb[[2]]$a)*100,"% chance that the true mastery is at least ",round(qbeta(mb[[2]]$a,rx$post_s1,rx$post_s2)*100,2),"%."))
  st5<-(paste0("The average mastery of comparable students reaching this criterion is ",am*100,"%."))
  curve(dbeta(x,rx$post_s1,rx$post_s2),ylab="Density",xlab="True Mastery",main="Distribution of True Mastery given performance Criterion is reached")
  freport<-rbind(st1,st11,st2,st3,st4,st5)
  ppost<-function(y){return(1-pbeta(y,rx$post_s1,rx$post_s2))}
  dpost<-function(y){return(dbeta(y,rx$post_s1,rx$post_s2))}
  return(list(freport,ppost,dpost))
}
