% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/transpile.R
\name{transpile_stata_module}
\alias{transpile_stata_module}
\title{Transpile and group do-files by thematic module}
\usage{
transpile_stata_module(year_dir, year, user = "iecon", output_dir = NULL)
}
\arguments{
\item{year_dir}{Path to a year directory (e.g., "do_files_iecon/2022")}

\item{year}{Year of the edition (character or numeric)}

\item{user}{Author name}

\item{output_dir}{Directory to write JSON recipes (NULL = no file output)}
}
\value{
A named list of Recipe objects, one per thematic module
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}

Processes all do-files in a year directory and groups them
into thematic Recipe objects (demographics, income, etc.).
}
\examples{
\dontrun{
# Requires a directory of .do files organized by year
recipes <- transpile_stata_module("do_files_iecon/2022", year = 2022)
names(recipes)
}
}
\seealso{
Other transpiler: 
\code{\link{parse_do_file}()},
\code{\link{parse_stata_labels}()},
\code{\link{transpile_coverage}()},
\code{\link{transpile_stata}()}
}
\concept{transpiler}
