% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/survey.R
\name{get_steps}
\alias{get_steps}
\title{get_steps}
\usage{
get_steps(svy)
}
\arguments{
\item{svy}{Survey object}
}
\value{
List of Step objects
}
\description{
Get steps from survey
}
\examples{
dt <- data.table::data.table(
  id = 1:5, age = c(25, 30, 45, 50, 60),
  w = rep(1, 5)
)
svy <- Survey$new(
  data = dt, edition = "2023", type = "ech",
  psu = NULL, engine = "data.table", weight = add_weight(annual = "w")
)
svy <- step_compute(svy, age2 = age * 2)
get_steps(svy) # list of Step objects
}
\seealso{
Other steps: 
\code{\link{bake_steps}()},
\code{\link{step_compute}()},
\code{\link{step_filter}()},
\code{\link{step_join}()},
\code{\link{step_recode}()},
\code{\link{step_remove}()},
\code{\link{step_rename}()},
\code{\link{step_validate}()},
\code{\link{view_graph}()}
}
\concept{steps}
\keyword{step}
\keyword{survey}
