% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/graphql-introspection.R
\name{meetupr_schema_search}
\alias{meetupr_schema_search}
\title{Search for types in the Meetup GraphQL API schema}
\usage{
meetupr_schema_search(pattern, schema = meetupr_schema())
}
\arguments{
\item{pattern}{A string pattern to search for in type names and descriptions.
The search is case-insensitive.}

\item{schema}{The schema object obtained from \code{meetupr_schema()}.}
}
\value{
A tibble with details about matching types:
\describe{
\item{type_name}{Name of the type}
\item{kind}{GraphQL kind (OBJECT, ENUM, INTERFACE, etc.)}
\item{description}{Human-readable description}
\item{field_count}{Number of fields in the type}
}
}
\description{
This function searches across all types in the schema by name or description.
Useful for discovering what data structures are
available (e.g., Event, Group, Venue, Member).
}
\examples{
\dontrun{
# Find all event-related types
meetupr_schema_search("event")

# Find location-related types
meetupr_schema_search("location")
}

}
