% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Utilities.R
\name{select_rows_cols_byname}
\alias{select_rows_cols_byname}
\title{Select (or deselect) rows or columns}
\usage{
select_rows_cols_byname(
  a,
  margin = c(1, 2),
  retain_pattern = "$^",
  remove_pattern = "$^",
  ignore.case = FALSE,
  perl = FALSE,
  fixed = FALSE,
  useBytes = FALSE
)
}
\arguments{
\item{a}{A matrix or a list of matrices.}

\item{margin}{\code{1} for rows, \code{2} for columns, or \code{c(1, 2)} (the default) for both.
Can be a string or vector of strings that indicate
row and/or column types.}

\item{retain_pattern}{An extended regex or list of extended regular expressions that specifies which columns of \code{m} to retain.
Default pattern ("$^") retains nothing.}

\item{remove_pattern}{An extended regex or list of extended regular expressions that specifies which columns of \code{m} to remove.
Default pattern ("$^") removes nothing.}

\item{ignore.case, perl, fixed, useBytes}{Arguments passed to \code{grep()}.}
}
\value{
A matrix that is a subset of \code{a} with columns selected by \code{retain_pattern} and \code{remove_pattern}.
}
\description{
Arguments indicate which columns are to be retained and which are to be removed
by routing to \code{\link[=select_rows_byname]{select_rows_byname()}} or \code{\link[=select_cols_byname]{select_cols_byname()}}
based on the value of \code{margin}.
\code{margin} can be a string or vector of strings that are matched
to row and column types.
}
\details{
If \code{a} is \code{NULL}, \code{NULL} is returned.

For maximum flexibility, arguments can be extended regex patterns
that are matched against row or column names.
If no row or column (depending on \code{margin})
names of \code{a} match the \code{retain_pattern}, \code{NULL} is returned.
If no row or column (depending on \code{margin})
names of \code{a} match the \code{remove_pattern}, \code{a} is returned.

Retaining takes precedence over removing, always.

Some typical patterns are:
\itemize{
\item{"^Electricity$|^Oil$": row or column names that are EXACTLY "Electricity" or "Oil".}
\item{"^Electricity|^Oil": row or column names that START WITH "Electricity" or "Oil".}
\item{"Electricity|Oil": row or column names that CONTAIN "Electricity" or "Oil" anywhere within them.}
}

If the row or column labels contain "[" or "]",
care should be taken to escape those characters.
\code{\link[Hmisc:escapeRegex]{Hmisc::escapeRegex()}} is helpful in such situations.
This function assumes that \code{retain_pattern} and \code{remove_pattern} have already been
suitably escaped.

Given a list of row or column names, a pattern can be constructed easily using
\code{\link[RCLabels:make_or_pattern]{RCLabels::make_or_pattern()}}.
\code{RCLabels::make_or_pattern()} escapes regex strings using \code{\link[Hmisc:escapeRegex]{Hmisc::escapeRegex()}}.

Note that the default \code{retain_pattern} and \code{remove_pattern} ("$^")
retain nothing and remove nothing.

Note that if all columns are removed from \code{a}, \code{NULL} is returned.
}
\examples{
m <- matrix(1:16, ncol = 4, dimnames=list(c(paste0("i", 1:4)), paste0("p", 1:4))) |> 
  setrowtype("Industries") |> setcoltype("Commodities")
select_rows_cols_byname(m, 
                        margin = 2, # for columns
                        retain_pattern = RCLabels::make_or_pattern(c("p1", "p4"), 
                        pattern_type = "exact"))
select_rows_cols_byname(m, 
                        margin = 2, 
                        remove_pattern = RCLabels::make_or_pattern(c("p1", "p3"), 
                        pattern_type = "exact"))
# Also works for lists and data frames
select_rows_cols_byname(list(m,m), margin = 2, 
                        retain_pattern = "^p1$|^p4$")
}
