% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/maidr.R
\name{show}
\alias{show}
\title{Display Interactive MAIDR Plot}
\usage{
show(plot = NULL, shiny = FALSE, as_widget = FALSE, ...)
}
\arguments{
\item{plot}{A ggplot2 object or NULL for Base R auto-detection}

\item{shiny}{If TRUE, returns just the SVG content instead of full HTML document}

\item{as_widget}{If TRUE, returns an htmlwidget object instead of opening in browser}

\item{...}{Additional arguments passed to internal functions}
}
\value{
Invisible NULL. The plot is displayed in RStudio Viewer or browser as a side effect.
}
\description{
Display a ggplot2 or Base R plot as an interactive, accessible visualization
using the MAIDR (Multimodal Access and Interactive Data Representation) system.
}
\examples{
# ggplot2 example
library(ggplot2)
p <- ggplot(mtcars, aes(x = factor(cyl), y = mpg)) +
  geom_bar(stat = "identity")
\donttest{
maidr::show(p)
}

# Base R example (requires interactive session for function patching)
if (interactive()) {
  barplot(c(10, 20, 30), names.arg = c("A", "B", "C"))
  maidr::show()
}
}
