% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/shiny.R
\name{render_maidr}
\alias{render_maidr}
\title{Render MAIDR Plot in Shiny Server}
\usage{
render_maidr(expr, env = parent.frame(), quoted = FALSE)
}
\arguments{
\item{expr}{An expression that returns a ggplot object}

\item{env}{The environment in which to evaluate expr}

\item{quoted}{Is expr a quoted expression}
}
\value{
A Shiny render function for use in server
}
\description{
Creates a Shiny render function for MAIDR widgets using htmlwidgets.
This provides automatic dependency injection and robust JavaScript initialization.
}
\examples{
if (interactive()) {
  library(shiny)
  library(ggplot2)
  server <- function(input, output) {
    output$myplot <- render_maidr({
      ggplot(mtcars, aes(x = factor(cyl), y = mpg)) +
        geom_bar(stat = "identity")
    })
  }
}
}
