% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/autoplot_persistence.R
\name{autoplot.persistingoutliers}
\alias{autoplot.persistingoutliers}
\title{Plots outlier persistence for a range of significance levels.}
\usage{
\method{autoplot}{persistingoutliers}(object, alpha = object$alpha, ...)
}
\arguments{
\item{object}{The output of the function \code{persisting_outliers}.}

\item{alpha}{The significance levels to plot.}

\item{...}{Other arguments currently ignored.}
}
\value{
A ggplot object.
}
\description{
This function plots outlier persistence for a range of significance levels
using the algorithm lookout, an outlier detection method that uses
leave-one-out kernel density estimates and generalized Pareto distributions
to find outliers.
}
\examples{
X <- rbind(
  data.frame(
    x = rnorm(500),
    y = rnorm(500)
  ),
  data.frame(
    x = rnorm(5, mean = 10, sd = 0.2),
    y = rnorm(5, mean = 10, sd = 0.2)
  )
)
plot(X, pch = 19)
outliers <- persisting_outliers(X, scale = FALSE)
autoplot(outliers)
}
