## ----setup, include=FALSE-----------------------------------------------------

knitr::opts_chunk$set(echo = TRUE, message = FALSE, warning = FALSE,
                      fig.width = 4, fig.height = 4, fig.align = "center")
# Packages --------------------------------------------------------------------
suppressPackageStartupMessages({
  suppressWarnings({
    library("latbias")
    library("sf")
    library("elevatr")
    library("rnaturalearth")
  })
})

options(tinytex.verbose = TRUE)

## ----echo=TRUE, eval=FALSE----------------------------------------------------
# library("latbias")
# library("sf")
# library("elevatr")
# library("rnaturalearth")

## ----study_case---------------------------------------------------------------
study_area <- rnaturalearth::ne_countries(scale = 50, continent = "Europe",
                                          country = "Sweden", type = "map_units", returnclass = "sf")
study_area <- sf::st_union(study_area)

## ----LBI_calculation, echo = TRUE, eval = FALSE-------------------------------
# lbi_sweden <-
#   LBI(study_area_id = "Sweden", study_area_polygon = study_area,
#       nobs = 10, nboot = 50, fact_location = 5, elevation = NULL)
# 
# lbi_sweden

## ----LBI_elevation, echo = TRUE, eval = FALSE---------------------------------
# # With elevation
# elevation_df <- elevatr::get_elev_raster(locations = st_as_sf(study_area),
#                                          z = 5)
# 
# lbi_elev <- LBI(study_area_id = "Sweden", study_area_polygon = study_area,
#                 nobs = 10, nboot = 10, fact_location = 5,
#                 elevation = elevation_df)

## ----one_bootstrap------------------------------------------------------------
lbi_sweden_all <-
  LBI(study_area_id = "Sweden", study_area_polygon = study_area,
      nobs = 10, nboot = 50, fact_location = 5, elevation = NULL,
      raw_output = TRUE)

## ----windrose-----------------------------------------------------------------
test <- as.data.frame(
  lbi_sweden_all$all[, c("study_area_id", "distance_km",
                         "bearing", "rep")])
test$distance_km <- as.numeric(test$distance_km)
windrose(data = test, spd = "distance_km", dir = "bearing")

