% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/metrics.R
\name{metric_cosine_similarity}
\alias{metric_cosine_similarity}
\title{Computes the cosine similarity between the labels and predictions.}
\usage{
metric_cosine_similarity(
  ...,
  name = "cosine_similarity",
  dtype = NULL,
  axis = -1L
)
}
\arguments{
\item{...}{For forward/backward compatability.}

\item{name}{(Optional) string name of the metric instance.}

\item{dtype}{(Optional) data type of the metric result.}

\item{axis}{(Optional) Defaults to \code{-1}. The dimension along which the cosine
similarity is computed.}
}
\value{
a \code{Metric} instance is returned. The \code{Metric} instance can be passed
directly to \code{compile(metrics = )}, or used as a standalone object. See
\code{?Metric} for example usage.
}
\description{
Formula:

\if{html}{\out{<div class="sourceCode r">}}\preformatted{loss <- sum(l2_norm(y_true) * l2_norm(y_pred))
}\if{html}{\out{</div>}}

See: \href{https://en.wikipedia.org/wiki/Cosine_similarity}{Cosine Similarity}.
This metric keeps the average cosine similarity between \code{predictions} and
\code{labels} over a stream of data.
}
\section{Examples}{
Standalone usage:

\if{html}{\out{<div class="sourceCode r">}}\preformatted{m <- metric_cosine_similarity(axis=2)
m$update_state(rbind(c(0., 1.), c(1., 1.)), rbind(c(1., 0.), c(1., 1.)))
m$result()
}\if{html}{\out{</div>}}

\if{html}{\out{<div class="sourceCode">}}\preformatted{## tf.Tensor(0.5, shape=(), dtype=float32)

}\if{html}{\out{</div>}}

\if{html}{\out{<div class="sourceCode r">}}\preformatted{m$reset_state()
m$update_state(rbind(c(0., 1.), c(1., 1.)), rbind(c(1., 0.), c(1., 1.)),
               sample_weight = c(0.3, 0.7))
m$result()
}\if{html}{\out{</div>}}

\if{html}{\out{<div class="sourceCode">}}\preformatted{## tf.Tensor(0.7, shape=(), dtype=float32)

}\if{html}{\out{</div>}}

Usage with \code{compile()} API:

\if{html}{\out{<div class="sourceCode r">}}\preformatted{model \%>\% compile(
  optimizer = 'sgd',
  loss = 'mse',
  metrics = list(metric_cosine_similarity(axis=2)))
}\if{html}{\out{</div>}}
}

\seealso{
\itemize{
\item \url{https://keras.io/api/metrics/regression_metrics#cosinesimilarity-class}
}

Other regression metrics: \cr
\code{\link{metric_concordance_correlation}()} \cr
\code{\link{metric_log_cosh_error}()} \cr
\code{\link{metric_mean_absolute_error}()} \cr
\code{\link{metric_mean_absolute_percentage_error}()} \cr
\code{\link{metric_mean_squared_error}()} \cr
\code{\link{metric_mean_squared_logarithmic_error}()} \cr
\code{\link{metric_pearson_correlation}()} \cr
\code{\link{metric_r2_score}()} \cr
\code{\link{metric_root_mean_squared_error}()} \cr

Other metrics: \cr
\code{\link{Metric}()} \cr
\code{\link{custom_metric}()} \cr
\code{\link{metric_auc}()} \cr
\code{\link{metric_binary_accuracy}()} \cr
\code{\link{metric_binary_crossentropy}()} \cr
\code{\link{metric_binary_focal_crossentropy}()} \cr
\code{\link{metric_binary_iou}()} \cr
\code{\link{metric_categorical_accuracy}()} \cr
\code{\link{metric_categorical_crossentropy}()} \cr
\code{\link{metric_categorical_focal_crossentropy}()} \cr
\code{\link{metric_categorical_hinge}()} \cr
\code{\link{metric_concordance_correlation}()} \cr
\code{\link{metric_f1_score}()} \cr
\code{\link{metric_false_negatives}()} \cr
\code{\link{metric_false_positives}()} \cr
\code{\link{metric_fbeta_score}()} \cr
\code{\link{metric_hinge}()} \cr
\code{\link{metric_huber}()} \cr
\code{\link{metric_iou}()} \cr
\code{\link{metric_kl_divergence}()} \cr
\code{\link{metric_log_cosh}()} \cr
\code{\link{metric_log_cosh_error}()} \cr
\code{\link{metric_mean}()} \cr
\code{\link{metric_mean_absolute_error}()} \cr
\code{\link{metric_mean_absolute_percentage_error}()} \cr
\code{\link{metric_mean_iou}()} \cr
\code{\link{metric_mean_squared_error}()} \cr
\code{\link{metric_mean_squared_logarithmic_error}()} \cr
\code{\link{metric_mean_wrapper}()} \cr
\code{\link{metric_one_hot_iou}()} \cr
\code{\link{metric_one_hot_mean_iou}()} \cr
\code{\link{metric_pearson_correlation}()} \cr
\code{\link{metric_poisson}()} \cr
\code{\link{metric_precision}()} \cr
\code{\link{metric_precision_at_recall}()} \cr
\code{\link{metric_r2_score}()} \cr
\code{\link{metric_recall}()} \cr
\code{\link{metric_recall_at_precision}()} \cr
\code{\link{metric_root_mean_squared_error}()} \cr
\code{\link{metric_sensitivity_at_specificity}()} \cr
\code{\link{metric_sparse_categorical_accuracy}()} \cr
\code{\link{metric_sparse_categorical_crossentropy}()} \cr
\code{\link{metric_sparse_top_k_categorical_accuracy}()} \cr
\code{\link{metric_specificity_at_sensitivity}()} \cr
\code{\link{metric_squared_hinge}()} \cr
\code{\link{metric_sum}()} \cr
\code{\link{metric_top_k_categorical_accuracy}()} \cr
\code{\link{metric_true_negatives}()} \cr
\code{\link{metric_true_positives}()} \cr
}
\concept{metrics}
\concept{regression metrics}
