% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/variable.R
\name{keras_variable}
\alias{keras_variable}
\title{Represents a backend-agnostic variable in Keras.}
\usage{
keras_variable(
  initializer,
  shape = NULL,
  dtype = NULL,
  trainable = TRUE,
  autocast = TRUE,
  aggregation = "none",
  synchronization = "auto",
  name = NULL,
  ...
)
}
\arguments{
\item{initializer}{Initial value or callable for initialization.
If a callable is used, it should take the arguments
\code{shape} and \code{dtype}.}

\item{shape}{Optional. Tuple for the variable's shape.
Required if \code{initializer} is a callable.}

\item{dtype}{Optional. Data type of the variable. Defaults to the global float
dtype type (\code{"float32"} if never configured).}

\item{trainable}{Optional. Boolean indicating if variable is trainable.
Defaults to \code{TRUE}.}

\item{autocast}{Optional. Boolean indicating whether the variable supports
autocasting. If \code{TRUE}, the layer may first convert the variable
to the compute data type when accessed. Defaults to \code{TRUE}.}

\item{aggregation}{Optional string, one of \code{NULL}, \code{"none"}, \code{"mean"},
\code{"sum"} or \code{"only_first_replica"} specifying how a distributed
variable will be aggregated. This serves as a semantic annotation,
to be taken into account by downstream backends or users. Defaults
to \code{"none"}.}

\item{synchronization}{Optional string specifying how distributed values should be synchronized.
Defaults to \code{"auto"}.}

\item{name}{Optional. A unique name for the variable. Automatically generated
if not set.}

\item{...}{Additional backend-specific keyword arguments forwarded to \code{keras$Variable()}.}
}
\description{
A \code{Variable} acts as a container for state. It holds a tensor value and can
be updated. With the JAX backend, variables are used to implement
"functionalization", the pattern of lifting stateful operations out of
a piece of computation to turn it into a stateless function.
}
\section{Attributes}{
\itemize{
\item \code{shape}: The shape of the variable (tuple of integers).
\item \code{ndim}: The number of dimensions of the variable (integer).
\item \code{dtype}: The data type of the variable (string).
\item \code{trainable}: Whether the variable is trainable (boolean).
\item \code{autocast}: Whether the variable supports autocasting (boolean).
\item \code{aggregation}: How a distributed variable will be aggregated (string).
\item \code{synchronization}: Strategy for synchronizing the variable across devices (string).
\item \code{value}: The current value of the variable (NumPy array or tensor).
\item \code{name}: The name of the variable (string).
\item \code{path}: The path of the variable within the Keras model or layer (string).
}
}

\section{Examples}{
\strong{Initializing a \code{Variable} with a NumPy array:}

\if{html}{\out{<div class="sourceCode r">}}\preformatted{initial_array <- array(1, c(3, 3))
variable_from_array <- keras_variable(initializer = initial_array)
}\if{html}{\out{</div>}}

\strong{Using a Keras initializer to create a \code{Variable}:}

\if{html}{\out{<div class="sourceCode r">}}\preformatted{variable_from_initializer <- keras_variable(
  initializer = initializer_ones(),
  shape = c(3, 3),
  dtype = "float32"
)
}\if{html}{\out{</div>}}

\if{html}{\out{<div class="sourceCode r">}}\preformatted{new_value <- array(0, c(3, 3))
variable_from_array$assign(new_value)
}\if{html}{\out{</div>}}

\if{html}{\out{<div class="sourceCode">}}\preformatted{## tf.Tensor(
## [[0. 0. 0.]
##  [0. 0. 0.]
##  [0. 0. 0.]], shape=(3, 3), dtype=float64)

}\if{html}{\out{</div>}}

\if{html}{\out{<div class="sourceCode r">}}\preformatted{# To modify a subset of values
value <- variable_from_array$value
value@r[1,] <- 99
invisible(variable_from_array$assign(value))
variable_from_array
}\if{html}{\out{</div>}}

\if{html}{\out{<div class="sourceCode">}}\preformatted{## <Variable path=variable, shape=(3, 3), dtype=float64, value=[[99. 99. 99.]
##  [ 0.  0.  0.]
##  [ 0.  0.  0.]]>

}\if{html}{\out{</div>}}

\strong{Marking a \code{Variable} as non-trainable:}

\if{html}{\out{<div class="sourceCode r">}}\preformatted{non_trainable_variable <- keras_variable(
  initializer = array(1, c(3, 3)),
  dtype = "float32",
  trainable = FALSE
)
}\if{html}{\out{</div>}}
}

